/*
 * Decompiled with CFR 0.152.
 */
package io.crate.lucene;

import io.crate.expression.symbol.Function;
import io.crate.geo.GeoJSONUtils;
import io.crate.lucene.FunctionLiteralPair;
import io.crate.lucene.FunctionToQuery;
import io.crate.lucene.InnerFunctionToQuery;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.lucene.RefAndLiteral;
import io.crate.types.DataTypes;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.mapper.GeoPointFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import org.locationtech.spatial4j.exception.InvalidShapeException;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.ShapeCollection;

class WithinQuery
implements FunctionToQuery,
InnerFunctionToQuery {
    WithinQuery() {
    }

    @Override
    public Query apply(Function parent, Function inner, LuceneQueryBuilder.Context context) {
        boolean negate;
        FunctionLiteralPair outerPair = new FunctionLiteralPair(parent);
        if (!outerPair.isValid()) {
            return null;
        }
        Query query = this.getQuery(inner, context);
        if (query == null) {
            return null;
        }
        boolean bl = negate = (Boolean)outerPair.input().value() == false;
        if (negate) {
            return Queries.not(query);
        }
        return query;
    }

    private Query getQuery(Function inner, LuceneQueryBuilder.Context context) {
        Geometry geometry;
        RefAndLiteral innerPair = RefAndLiteral.of(inner);
        if (innerPair == null) {
            return null;
        }
        if (innerPair.reference().valueType().equals(DataTypes.GEO_SHAPE)) {
            return LuceneQueryBuilder.genericFunctionFilter(inner, context);
        }
        GeoPointFieldMapper.GeoPointFieldType geoPointFieldType = WithinQuery.getGeoPointFieldType(innerPair.reference().column().fqn(), context.mapperService);
        Object geoJSON = DataTypes.GEO_SHAPE.implicitCast(innerPair.literal().value());
        Shape shape = GeoJSONUtils.map2Shape((Map<String, Object>)geoJSON);
        if (shape instanceof ShapeCollection) {
            int i = 0;
            ShapeCollection collection = (ShapeCollection)shape;
            org.locationtech.jts.geom.Polygon[] polygons = new org.locationtech.jts.geom.Polygon[collection.size()];
            for (Shape s : collection.getShapes()) {
                Geometry subGeometry = JtsSpatialContext.GEO.getShapeFactory().getGeometryFrom(s);
                if (subGeometry instanceof org.locationtech.jts.geom.Polygon) {
                    polygons[i++] = (org.locationtech.jts.geom.Polygon)subGeometry;
                    continue;
                }
                throw new InvalidShapeException("Shape collection must contain only Polygon shapes.");
            }
            GeometryFactory geometryFactory = JtsSpatialContext.GEO.getShapeFactory().getGeometryFactory();
            geometry = geometryFactory.createMultiPolygon(polygons);
        } else {
            geometry = JtsSpatialContext.GEO.getShapeFactory().getGeometryFrom(shape);
        }
        return WithinQuery.getPolygonQuery(geometry, geoPointFieldType);
    }

    private static Query getPolygonQuery(Geometry geometry, GeoPointFieldMapper.GeoPointFieldType fieldType) {
        Coordinate[] coordinates = geometry.getCoordinates();
        if (!CoordinateArrays.isRing((Coordinate[])coordinates)) {
            coordinates = Arrays.copyOf(coordinates, coordinates.length + 1);
            coordinates[coordinates.length - 1] = coordinates[0];
        }
        double[] lats = new double[coordinates.length];
        double[] lons = new double[coordinates.length];
        for (int i = 0; i < coordinates.length; ++i) {
            lats[i] = coordinates[i].y;
            lons[i] = coordinates[i].x;
        }
        return LatLonPoint.newPolygonQuery((String)fieldType.name(), (Polygon[])new Polygon[]{new Polygon(lats, lons, new Polygon[0])});
    }

    private static GeoPointFieldMapper.GeoPointFieldType getGeoPointFieldType(String fieldName, MapperService mapperService) {
        MappedFieldType fieldType = mapperService.fullName(fieldName);
        if (fieldType == null) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "column \"%s\" doesn't exist", fieldName));
        }
        if (!(fieldType instanceof GeoPointFieldMapper.GeoPointFieldType)) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "column \"%s\" isn't of type geo_point", fieldName));
        }
        return (GeoPointFieldMapper.GeoPointFieldType)fieldType;
    }

    @Override
    public Query apply(Function input, LuceneQueryBuilder.Context context) {
        return this.getQuery(input, context);
    }
}

