/*
 * Decompiled with CFR 0.152.
 */
package io.crate.lucene;

import com.google.common.collect.Iterables;
import io.crate.analyze.MatchOptionsAnalysis;
import io.crate.data.Input;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.geo.GeoJSONUtils;
import io.crate.lucene.FunctionToQuery;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.lucene.match.MatchQueries;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.spatial.prefix.PrefixTreeStrategy;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.index.mapper.GeoShapeFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryShardContext;
import org.locationtech.spatial4j.shape.Shape;

class ToMatchQuery
implements FunctionToQuery {
    ToMatchQuery() {
    }

    @Override
    public Query apply(Function input, LuceneQueryBuilder.Context context) throws IOException {
        List<Symbol> arguments = input.arguments();
        assert (arguments.size() == 4) : "invalid number of arguments";
        assert (Symbol.isLiteral(arguments.get(0), DataTypes.UNTYPED_OBJECT)) : "fields must be literal";
        assert (Symbol.isLiteral(arguments.get(2), DataTypes.STRING)) : "matchType must be literal";
        Symbol queryTerm = arguments.get(1);
        if (!(queryTerm instanceof Input)) {
            throw new IllegalArgumentException("queryTerm must be a literal");
        }
        Object queryTermVal = ((Input)((Object)queryTerm)).value();
        if (queryTermVal == null) {
            throw new IllegalArgumentException("cannot use NULL as query term in match predicate");
        }
        if (queryTerm.valueType().equals(DataTypes.GEO_SHAPE)) {
            return this.geoMatch(context, arguments, queryTermVal);
        }
        return ToMatchQuery.stringMatch(context, arguments, queryTermVal);
    }

    private Query geoMatch(LuceneQueryBuilder.Context context, List<Symbol> arguments, Object queryTerm) {
        Map fields = (Map)((Literal)arguments.get(0)).value();
        String fieldName = (String)Iterables.getOnlyElement(fields.keySet());
        MappedFieldType fieldType = context.mapperService.fullName(fieldName);
        GeoShapeFieldMapper.GeoShapeFieldType geoShapeFieldType = (GeoShapeFieldMapper.GeoShapeFieldType)fieldType;
        String matchType = (String)((Input)((Object)arguments.get(2))).value();
        Shape shape = GeoJSONUtils.map2Shape((Map)queryTerm);
        ShapeRelation relation = ShapeRelation.getRelationByName(matchType);
        assert (relation != null) : "invalid matchType: " + matchType;
        PrefixTreeStrategy prefixTreeStrategy = geoShapeFieldType.defaultStrategy();
        if (relation == ShapeRelation.DISJOINT) {
            BooleanQuery.Builder bool = new BooleanQuery.Builder();
            TermRangeQuery exists = new TermRangeQuery(fieldName, null, null, true, true);
            Query intersects = prefixTreeStrategy.makeQuery(this.getArgs(shape, ShapeRelation.INTERSECTS));
            bool.add((Query)exists, BooleanClause.Occur.MUST);
            bool.add(intersects, BooleanClause.Occur.MUST_NOT);
            return new ConstantScoreQuery((Query)bool.build());
        }
        SpatialArgs spatialArgs = this.getArgs(shape, relation);
        return prefixTreeStrategy.makeQuery(spatialArgs);
    }

    private SpatialArgs getArgs(Shape shape, ShapeRelation relation) {
        switch (relation) {
            case INTERSECTS: {
                return new SpatialArgs(SpatialOperation.Intersects, shape);
            }
            case DISJOINT: {
                return new SpatialArgs(SpatialOperation.IsDisjointTo, shape);
            }
            case WITHIN: {
                return new SpatialArgs(SpatialOperation.IsWithin, shape);
            }
        }
        throw this.invalidMatchType(relation.getRelationName());
    }

    private AssertionError invalidMatchType(String matchType) {
        throw new AssertionError((Object)String.format(Locale.ENGLISH, "Invalid match type: %s. Analyzer should have made sure that it is valid", matchType));
    }

    private static Query stringMatch(LuceneQueryBuilder.Context context, List<Symbol> arguments, Object queryTerm) throws IOException {
        Map fields = (Map)((Literal)arguments.get(0)).value();
        String queryString = (String)queryTerm;
        String matchType = (String)((Literal)arguments.get(2)).value();
        Map options = (Map)((Literal)arguments.get(3)).value();
        MatchOptionsAnalysis.validate(options);
        if (fields.size() == 1) {
            return ToMatchQuery.singleMatchQuery(context.queryShardContext, fields.entrySet().iterator().next(), queryString, matchType, options);
        }
        fields.replaceAll((s, o) -> {
            if (o instanceof Number) {
                return Float.valueOf(((Number)o).floatValue());
            }
            return null;
        });
        return MatchQueries.multiMatch(context.queryShardContext, matchType, fields, queryString, options);
    }

    private static Query singleMatchQuery(QueryShardContext queryShardContext, Map.Entry<String, Object> entry, String queryString, String matchType, Map<String, Object> options) throws IOException {
        Query query = MatchQueries.singleMatch(queryShardContext, entry.getKey(), queryString, matchType, options);
        Object boost = entry.getValue();
        if (boost instanceof Number) {
            return new BoostQuery(query, ((Number)boost).floatValue());
        }
        return query;
    }
}

