/*
 * Decompiled with CFR 0.152.
 */
package io.crate.lucene;

import io.crate.data.Input;
import io.crate.expression.symbol.Function;
import io.crate.lucene.FunctionLiteralPair;
import io.crate.lucene.InnerFunctionToQuery;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.lucene.RefAndLiteral;
import io.crate.metadata.Reference;
import io.crate.types.ArrayType;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryShardContext;

class SubscriptQuery
implements InnerFunctionToQuery {
    private static final Map<String, PreFilterQueryBuilder> PRE_FILTER_QUERY_BUILDER_BY_OP = Map.of("op_=", MappedFieldType::termQuery, "op_>=", (fieldType, value, context) -> fieldType.rangeQuery(value, null, true, false, null, null, context), "op_>", (fieldType, value, context) -> fieldType.rangeQuery(value, null, false, false, null, null, context), "op_<=", (fieldType, value, context) -> fieldType.rangeQuery(null, value, false, true, null, null, context), "op_<", (fieldType, value, context) -> fieldType.rangeQuery(null, value, false, false, null, null, context));

    SubscriptQuery() {
    }

    @Override
    @Nullable
    public Query apply(Function parent, Function inner, LuceneQueryBuilder.Context context) throws IOException {
        assert (inner.name().equals("subscript")) : "function must be subscript";
        RefAndLiteral innerPair = RefAndLiteral.of(inner);
        if (innerPair == null) {
            return null;
        }
        Reference reference = innerPair.reference();
        if (DataTypes.isArray(innerPair.reference().valueType())) {
            PreFilterQueryBuilder preFilterQueryBuilder = PRE_FILTER_QUERY_BUILDER_BY_OP.get(parent.name());
            if (preFilterQueryBuilder == null) {
                return null;
            }
            FunctionLiteralPair functionLiteralPair = new FunctionLiteralPair(parent);
            if (!functionLiteralPair.isValid()) {
                return null;
            }
            Input input = functionLiteralPair.input();
            MappedFieldType fieldType = context.getFieldTypeOrNull(reference.column().fqn());
            if (fieldType == null) {
                if (ArrayType.unnest(reference.valueType()).id() == 12) {
                    return null;
                }
                return Queries.newMatchNoDocsQuery("column doesn't exist in this index");
            }
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            builder.add(preFilterQueryBuilder.buildQuery(fieldType, input.value(), context.queryShardContext), BooleanClause.Occur.MUST);
            builder.add(LuceneQueryBuilder.genericFunctionFilter(parent, context), BooleanClause.Occur.FILTER);
            return builder.build();
        }
        return null;
    }

    private static interface PreFilterQueryBuilder {
        public Query buildQuery(MappedFieldType var1, Object var2, QueryShardContext var3);
    }
}

