/*
 * Decompiled with CFR 0.152.
 */
package io.crate.lucene;

import io.crate.expression.RegexpFlags;
import io.crate.expression.symbol.Function;
import io.crate.lucene.FunctionToQuery;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.lucene.RefAndLiteral;
import io.crate.lucene.match.CrateRegexQuery;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;

class RegexpMatchQuery
implements FunctionToQuery {
    RegexpMatchQuery() {
    }

    private static Query toLuceneRegexpQuery(String fieldName, String value) {
        return new ConstantScoreQuery((Query)new RegexpQuery(new Term(fieldName, value), 255));
    }

    @Override
    public Query apply(Function input, LuceneQueryBuilder.Context context) {
        RefAndLiteral refAndLiteral = RefAndLiteral.of(input);
        if (refAndLiteral == null) {
            return null;
        }
        String fieldName = refAndLiteral.reference().column().fqn();
        String pattern = (String)refAndLiteral.literal().value();
        if (pattern == null) {
            return null;
        }
        if (RegexpFlags.isPcrePattern(pattern)) {
            return new CrateRegexQuery(new Term(fieldName, pattern));
        }
        return RegexpMatchQuery.toLuceneRegexpQuery(fieldName, pattern);
    }
}

