/*
 * Decompiled with CFR 0.152.
 */
package io.crate.lucene;

import io.crate.expression.symbol.Function;
import io.crate.lucene.FunctionToQuery;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.lucene.RefAndLiteral;
import io.crate.lucene.match.CrateRegexQuery;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;

class RegexMatchQueryCaseInsensitive
implements FunctionToQuery {
    RegexMatchQueryCaseInsensitive() {
    }

    @Override
    public Query apply(Function input, LuceneQueryBuilder.Context context) {
        RefAndLiteral refAndLiteral = RefAndLiteral.of(input);
        if (refAndLiteral == null) {
            return null;
        }
        String fieldName = refAndLiteral.reference().column().fqn();
        Object value = refAndLiteral.literal().value();
        if (value instanceof String) {
            return new CrateRegexQuery(new Term(fieldName, (String)value), 66);
        }
        throw new IllegalArgumentException("Can only use ~* with patterns of type string");
    }
}

