/*
 * Decompiled with CFR 0.152.
 */
package io.crate.lucene;

import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.Reference;
import java.util.List;
import javax.annotation.Nullable;

final class RefAndLiteral {
    private final Reference ref;
    private final Literal literal;

    @Nullable
    public static RefAndLiteral of(Function function) {
        List<Symbol> args = function.arguments();
        assert (args.size() == 2) : "Function must have 2 arguments";
        Symbol fst = args.get(0);
        Symbol snd = args.get(1);
        if (fst instanceof Reference && snd instanceof Literal) {
            return new RefAndLiteral((Reference)fst, (Literal)snd);
        }
        return null;
    }

    private RefAndLiteral(Reference ref, Literal literal) {
        this.ref = ref;
        this.literal = literal;
    }

    Reference reference() {
        return this.ref;
    }

    Literal literal() {
        return this.literal;
    }
}

