/*
 * Decompiled with CFR 0.152.
 */
package io.crate.lucene;

import io.crate.common.collections.Tuple;
import io.crate.expression.symbol.Function;
import io.crate.lucene.FieldTypeLookup;
import io.crate.lucene.FunctionToQuery;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.lucene.RefAndLiteral;
import io.crate.metadata.Reference;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryShardContext;

class RangeQuery
implements FunctionToQuery {
    private final boolean includeLower;
    private final boolean includeUpper;
    private final java.util.function.Function<Object, Tuple<?, ?>> boundsFunction;
    private static final java.util.function.Function<Object, Tuple<?, ?>> LOWER_BOUND = in -> new Tuple<Object, Object>(in, null);
    private static final java.util.function.Function<Object, Tuple<?, ?>> UPPER_BOUND = in -> new Tuple<Object, Object>(null, in);

    RangeQuery(String comparison) {
        switch (comparison) {
            case "lt": {
                this.boundsFunction = UPPER_BOUND;
                this.includeLower = false;
                this.includeUpper = false;
                break;
            }
            case "gt": {
                this.boundsFunction = LOWER_BOUND;
                this.includeLower = false;
                this.includeUpper = false;
                break;
            }
            case "lte": {
                this.boundsFunction = UPPER_BOUND;
                this.includeLower = false;
                this.includeUpper = true;
                break;
            }
            case "gte": {
                this.boundsFunction = LOWER_BOUND;
                this.includeLower = true;
                this.includeUpper = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid comparison");
            }
        }
    }

    @Override
    public Query apply(Function input, LuceneQueryBuilder.Context context) {
        RefAndLiteral refAndLiteral = RefAndLiteral.of(input);
        if (refAndLiteral == null) {
            return null;
        }
        return this.toQuery(refAndLiteral.reference(), refAndLiteral.literal().value(), context::getFieldTypeOrNull, context.queryShardContext);
    }

    Query toQuery(Reference reference, Object value, FieldTypeLookup fieldTypeLookup, QueryShardContext queryShardContext) {
        String columnName = reference.column().fqn();
        MappedFieldType fieldType = fieldTypeLookup.get(columnName);
        if (fieldType == null) {
            return Queries.newMatchNoDocsQuery("column does not exist in this index");
        }
        Tuple<?, ?> bounds = this.boundsFunction.apply(value);
        assert (bounds != null) : "bounds must not be null";
        return fieldType.rangeQuery(bounds.v1(), bounds.v2(), this.includeLower, this.includeUpper, null, null, queryShardContext);
    }
}

