/*
 * Decompiled with CFR 0.152.
 */
package io.crate.lucene;

import io.crate.expression.operator.any.AnyOperators;
import io.crate.expression.predicate.IsNullPredicate;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.lucene.FunctionToQuery;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.Reference;
import io.crate.sql.tree.ColumnPolicy;
import io.crate.types.DataTypes;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.query.ExistsQueryBuilder;

final class NotQuery
implements FunctionToQuery {
    private final SymbolToNotNullRangeQueryArgs INNER_VISITOR = new SymbolToNotNullRangeQueryArgs();
    private final LuceneQueryBuilder.Visitor visitor;

    public NotQuery(LuceneQueryBuilder.Visitor visitor) {
        this.visitor = visitor;
    }

    @Override
    public Query apply(Function input, LuceneQueryBuilder.Context context) {
        Function innerFunction;
        assert (input != null) : "function must not be null";
        assert (input.arguments().size() == 1) : "function's number of arguments must be 1";
        Symbol arg = input.arguments().get(0);
        if (arg instanceof Function && ((Function)arg).name().equals("op_isnull") && (innerFunction = (Function)arg).arguments().size() == 1 && innerFunction.arguments().get(0) instanceof Reference) {
            Reference ref = (Reference)innerFunction.arguments().get(0);
            if (ref.columnPolicy() == ColumnPolicy.IGNORED) {
                return null;
            }
            return ExistsQueryBuilder.newFilter(context.queryShardContext, ref.column().fqn());
        }
        Query innerQuery = arg.accept(this.visitor, context);
        Query notX = Queries.not(innerQuery);
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(notX, BooleanClause.Occur.MUST);
        SymbolToNotNullContext ctx = new SymbolToNotNullContext();
        arg.accept(this.INNER_VISITOR, ctx);
        for (Reference reference : ctx.references()) {
            String columnName = reference.column().fqn();
            if (!reference.isNullable()) continue;
            builder.add(ExistsQueryBuilder.newFilter(context.queryShardContext, columnName), BooleanClause.Occur.MUST);
        }
        if (ctx.hasStrictThreeValuedLogicFunction) {
            Function isNullFunction = new Function(IsNullPredicate.SIGNATURE, Collections.singletonList(arg), DataTypes.BOOLEAN);
            builder.add(Queries.not(LuceneQueryBuilder.genericFunctionFilter(isNullFunction, context)), BooleanClause.Occur.MUST);
        }
        return builder.build();
    }

    private static class SymbolToNotNullRangeQueryArgs
    extends SymbolVisitor<SymbolToNotNullContext, Void> {
        private final Set<String> STRICT_3VL_FUNCTIONS = Set.of(AnyOperators.Type.EQ.opName(), AnyOperators.Type.NEQ.opName(), AnyOperators.Type.GTE.opName(), AnyOperators.Type.GT.opName(), AnyOperators.Type.LTE.opName(), AnyOperators.Type.LT.opName(), "any_like", "any_not_like", "coalesce");

        private SymbolToNotNullRangeQueryArgs() {
        }

        @Override
        public Void visitReference(Reference symbol, SymbolToNotNullContext context) {
            context.add(symbol);
            return null;
        }

        @Override
        public Void visitFunction(Function function, SymbolToNotNullContext context) {
            String functionName = function.name();
            if ("ignore3vl".equals(functionName)) {
                return null;
            }
            if (!this.STRICT_3VL_FUNCTIONS.contains(functionName)) {
                for (Symbol arg : function.arguments()) {
                    arg.accept(this, context);
                }
            } else {
                context.hasStrictThreeValuedLogicFunction = true;
            }
            return null;
        }
    }

    private static class SymbolToNotNullContext {
        private final HashSet<Reference> references = new HashSet();
        boolean hasStrictThreeValuedLogicFunction = false;

        private SymbolToNotNullContext() {
        }

        void add(Reference symbol) {
            this.references.add(symbol);
        }

        Set<Reference> references() {
            return this.references;
        }
    }
}

