/*
 * Decompiled with CFR 0.152.
 */
package io.crate.lucene;

import io.crate.data.Input;
import io.crate.exceptions.UnsupportedFeatureException;
import io.crate.execution.engine.collect.DocInputFactory;
import io.crate.expression.InputFactory;
import io.crate.expression.eval.EvaluatingNormalizer;
import io.crate.expression.eval.NullEliminator;
import io.crate.expression.operator.any.AnyOperators;
import io.crate.expression.reference.doc.lucene.CollectorContext;
import io.crate.expression.reference.doc.lucene.LuceneCollectorExpression;
import io.crate.expression.reference.doc.lucene.LuceneReferenceResolver;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolType;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.expression.symbol.Symbols;
import io.crate.expression.symbol.format.Style;
import io.crate.lucene.AnyEqQuery;
import io.crate.lucene.AnyLikeQuery;
import io.crate.lucene.AnyNeqQuery;
import io.crate.lucene.AnyNotLikeQuery;
import io.crate.lucene.AnyRangeQuery;
import io.crate.lucene.ArrayLengthQuery;
import io.crate.lucene.CIDRRangeQuery;
import io.crate.lucene.DistanceQuery;
import io.crate.lucene.EqQuery;
import io.crate.lucene.FieldTypeLookup;
import io.crate.lucene.FunctionToQuery;
import io.crate.lucene.GenericFunctionQuery;
import io.crate.lucene.InnerFunctionToQuery;
import io.crate.lucene.IsNullQuery;
import io.crate.lucene.LikeQuery;
import io.crate.lucene.NotQuery;
import io.crate.lucene.RangeQuery;
import io.crate.lucene.RegexMatchQueryCaseInsensitive;
import io.crate.lucene.RegexpMatchQuery;
import io.crate.lucene.SubscriptQuery;
import io.crate.lucene.ToMatchQuery;
import io.crate.lucene.WithinQuery;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.DocReferences;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.doc.DocSysColumns;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.sql.tree.ColumnPolicy;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.cache.IndexCache;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.QueryShardContext;

@Singleton
public class LuceneQueryBuilder {
    private static final Logger LOGGER = LogManager.getLogger(LuceneQueryBuilder.class);
    private static final Visitor VISITOR = new Visitor();
    private final NodeContext nodeCtx;

    @Inject
    public LuceneQueryBuilder(NodeContext nodeCtx) {
        this.nodeCtx = nodeCtx;
    }

    public Context convert(Symbol query, TransactionContext txnCtx, MapperService mapperService, String indexName, QueryShardContext queryShardContext, DocTableInfo table, IndexCache indexCache) throws UnsupportedFeatureException {
        LuceneReferenceResolver refResolver = new LuceneReferenceResolver(indexName, mapperService::fullName, table.partitionedByColumns());
        EvaluatingNormalizer normalizer = new EvaluatingNormalizer(this.nodeCtx, RowGranularity.PARTITION, refResolver, null);
        Context ctx = new Context(txnCtx, this.nodeCtx, mapperService, indexCache, queryShardContext, indexName, table.partitionedByColumns());
        CoordinatorTxnCtx coordinatorTxnCtx = CoordinatorTxnCtx.systemTransactionContext();
        ctx.query = NullEliminator.eliminateNullsIfPossible(DocReferences.inverseSourceLookup(normalizer.normalize(query, coordinatorTxnCtx)), s -> normalizer.normalize((Symbol)s, coordinatorTxnCtx)).accept(VISITOR, ctx);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("WHERE CLAUSE [{}] -> LUCENE QUERY [{}] ", (Object)query.toString(Style.UNQUALIFIED), (Object)ctx.query);
        }
        return ctx;
    }

    static Query termsQuery(@Nullable MappedFieldType fieldType, List values, QueryShardContext context) {
        if (fieldType == null) {
            return Queries.newMatchNoDocsQuery("column does not exist in this index");
        }
        return fieldType.termsQuery(values, context);
    }

    static List asList(Literal literal) {
        Object val = literal.value();
        return ((List)val).stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    static Query genericFunctionFilter(Function function, Context context) {
        if (function.valueType() != DataTypes.BOOLEAN) {
            LuceneQueryBuilder.raiseUnsupported(function);
        }
        function = (Function)DocReferences.toSourceLookup(function, r -> r.columnPolicy() == ColumnPolicy.IGNORED || r.valueType() == DataTypes.GEO_POINT);
        InputFactory.Context<LuceneCollectorExpression<?>> ctx = context.docInputFactory.getCtx(context.txnCtx);
        Input<Boolean> condition = ctx.add(function);
        List<LuceneCollectorExpression<?>> expressions = ctx.expressions();
        CollectorContext collectorContext = new CollectorContext();
        for (LuceneCollectorExpression luceneCollectorExpression : expressions) {
            luceneCollectorExpression.startCollect(collectorContext);
        }
        return new GenericFunctionQuery(function, expressions, condition);
    }

    private static void raiseUnsupported(Function function) {
        throw new UnsupportedOperationException(Symbols.format("Cannot convert function %s into a query", function));
    }

    public static class Context {
        Query query;
        final Map<String, Object> filteredFieldValues = new HashMap<String, Object>();
        final DocInputFactory docInputFactory;
        final MapperService mapperService;
        final IndexCache indexCache;
        private final TransactionContext txnCtx;
        final QueryShardContext queryShardContext;
        static final Set<String> FILTERED_FIELDS = Set.of("_score");
        static final Map<String, String> UNSUPPORTED_FIELDS = Map.of("_version", "\"_version\" column can only be used in the WHERE clause with equals comparisons and if there are also equals comparisons on primary key columns", "_seq_no", "\"_seq_no\" and \"_primary_term\" columns can only be used together in the WHERE clause with equals comparisons and if there are also equals comparisons on primary key columns", "_primary_term", "\"_seq_no\" and \"_primary_term\" columns can only be used together in the WHERE clause with equals comparisons and if there are also equals comparisons on primary key columns");

        Context(TransactionContext txnCtx, NodeContext nodeCtx, MapperService mapperService, IndexCache indexCache, QueryShardContext queryShardContext, String indexName, List<Reference> partitionColumns) {
            this.txnCtx = txnCtx;
            this.queryShardContext = queryShardContext;
            FieldTypeLookup typeLookup = mapperService::fullName;
            this.docInputFactory = new DocInputFactory(nodeCtx, new LuceneReferenceResolver(indexName, typeLookup, partitionColumns));
            this.mapperService = mapperService;
            this.indexCache = indexCache;
        }

        public Query query() {
            return this.query;
        }

        @Nullable
        public Float minScore() {
            Object score = this.filteredFieldValues.get("_score");
            if (score == null) {
                return null;
            }
            return Float.valueOf(((Number)score).floatValue());
        }

        @Nullable
        public String unsupportedMessage(String field) {
            return UNSUPPORTED_FIELDS.get(field);
        }

        @Nullable
        MappedFieldType getFieldTypeOrNull(String fqColumnName) {
            return this.mapperService.fullName(fqColumnName);
        }

        public QueryShardContext queryShardContext() {
            return this.queryShardContext;
        }
    }

    static class Visitor
    extends SymbolVisitor<Context, Query> {
        private static final EqQuery EQ_QUERY = new EqQuery();
        private static final RangeQuery LT_QUERY = new RangeQuery("lt");
        private static final RangeQuery LTE_QUERY = new RangeQuery("lte");
        private static final RangeQuery GT_QUERY = new RangeQuery("gt");
        private static final RangeQuery GTE_QUERY = new RangeQuery("gte");
        private static final CIDRRangeQuery LLT_QUERY = new CIDRRangeQuery();
        private static final WithinQuery WITHIN_QUERY = new WithinQuery();
        private final Map<String, FunctionToQuery> functions = Map.ofEntries(Map.entry("within", WITHIN_QUERY), Map.entry("op_and", new AndQuery()), Map.entry("op_or", new OrQuery()), Map.entry("op_=", EQ_QUERY), Map.entry("op_<", LT_QUERY), Map.entry("op_<=", LTE_QUERY), Map.entry("op_>=", GTE_QUERY), Map.entry("op_>", GT_QUERY), Map.entry("op_<<", LLT_QUERY), Map.entry("op_like", new LikeQuery(false)), Map.entry("op_ilike", new LikeQuery(true)), Map.entry("op_not", new NotQuery(this)), Map.entry("ignore3vl", new Ignore3vlQuery()), Map.entry("op_isnull", new IsNullQuery()), Map.entry("match", new ToMatchQuery()), Map.entry(AnyOperators.Type.EQ.opName(), new AnyEqQuery()), Map.entry(AnyOperators.Type.NEQ.opName(), new AnyNeqQuery()), Map.entry(AnyOperators.Type.LT.opName(), new AnyRangeQuery("gt", "lt")), Map.entry(AnyOperators.Type.LTE.opName(), new AnyRangeQuery("gte", "lte")), Map.entry(AnyOperators.Type.GTE.opName(), new AnyRangeQuery("lte", "gte")), Map.entry(AnyOperators.Type.GT.opName(), new AnyRangeQuery("lt", "gt")), Map.entry("any_like", new AnyLikeQuery(false)), Map.entry("any_not_like", new AnyNotLikeQuery(false)), Map.entry("any_ilike", new AnyLikeQuery(true)), Map.entry("any_not_ilike", new AnyNotLikeQuery(true)), Map.entry("op_~", new RegexpMatchQuery()), Map.entry("op_~*", new RegexMatchQueryCaseInsensitive()));
        private final Map<String, InnerFunctionToQuery> innerFunctions = Map.of("distance", new DistanceQuery(), "within", WITHIN_QUERY, "subscript", new SubscriptQuery(), "array_length", new ArrayLengthQuery(), "array_upper", new ArrayLengthQuery());

        Visitor() {
        }

        @Override
        public Query visitFunction(Function function, Context context) {
            Query query;
            assert (function != null) : "function must not be null";
            if (Visitor.fieldIgnored(function, context)) {
                return Queries.newMatchAllQuery();
            }
            FunctionToQuery toQuery = this.functions.get((function = Visitor.rewriteAndValidateFields(function, context)).name());
            if (toQuery == null) {
                return LuceneQueryBuilder.genericFunctionFilter(function, context);
            }
            try {
                query = toQuery.apply(function, context);
            }
            catch (IOException e) {
                throw ExceptionsHelper.convertToRuntime(e);
            }
            catch (UnsupportedOperationException e) {
                return LuceneQueryBuilder.genericFunctionFilter(function, context);
            }
            if (query == null && (query = this.queryFromInnerFunction(function, context)) == null) {
                return LuceneQueryBuilder.genericFunctionFilter(function, context);
            }
            return query;
        }

        private Query queryFromInnerFunction(Function function, Context context) {
            for (Symbol symbol : function.arguments()) {
                String functionName;
                InnerFunctionToQuery functionToQuery;
                if (symbol.symbolType() != SymbolType.FUNCTION || (functionToQuery = this.innerFunctions.get(functionName = ((Function)symbol).name())) == null) continue;
                try {
                    Query query = functionToQuery.apply(function, (Function)symbol, context);
                    if (query == null) continue;
                    return query;
                }
                catch (IOException e) {
                    throw ExceptionsHelper.convertToRuntime(e);
                }
            }
            return null;
        }

        private static boolean fieldIgnored(Function function, Context context) {
            if (function.arguments().size() != 2) {
                return false;
            }
            Symbol left = function.arguments().get(0);
            Symbol right = function.arguments().get(1);
            if (left.symbolType() == SymbolType.REFERENCE && right.symbolType().isValueSymbol()) {
                String columnName = ((Reference)left).column().name();
                if (Context.FILTERED_FIELDS.contains(columnName)) {
                    context.filteredFieldValues.put(columnName, ((Input)((Object)right)).value());
                    return true;
                }
                String unsupportedMessage = Context.UNSUPPORTED_FIELDS.get(columnName);
                if (unsupportedMessage != null) {
                    throw new UnsupportedFeatureException(unsupportedMessage);
                }
            }
            return false;
        }

        private static Function rewriteAndValidateFields(Function function, Context context) {
            List<Symbol> arguments = function.arguments();
            if (arguments.size() == 2) {
                Symbol left = arguments.get(0);
                Symbol right = arguments.get(1);
                if (left.symbolType() == SymbolType.REFERENCE && right.symbolType().isValueSymbol()) {
                    Reference ref = (Reference)left;
                    if (ref.column().equals(DocSysColumns.UID)) {
                        return new Function(function.signature(), List.of(DocSysColumns.forTable(ref.ident().tableIdent(), DocSysColumns.ID), right), function.valueType());
                    }
                    String unsupportedMessage = context.unsupportedMessage(ref.column().name());
                    if (unsupportedMessage != null) {
                        throw new UnsupportedFeatureException(unsupportedMessage);
                    }
                }
            }
            return function;
        }

        @Override
        public Query visitReference(Reference symbol, Context context) {
            if (symbol.valueType() == DataTypes.BOOLEAN) {
                MappedFieldType fieldType = context.getFieldTypeOrNull(symbol.column().fqn());
                if (fieldType == null) {
                    return Queries.newMatchNoDocsQuery("column does not exist in this index");
                }
                return fieldType.termQuery(true, context.queryShardContext());
            }
            return (Query)super.visitReference(symbol, context);
        }

        @Override
        public Query visitLiteral(Literal literal, Context context) {
            Object value = literal.value();
            if (value == null) {
                return Queries.newMatchNoDocsQuery("WHERE null -> no match");
            }
            try {
                return (Boolean)value != false ? Queries.newMatchAllQuery() : Queries.newMatchNoDocsQuery("WHERE false -> no match");
            }
            catch (ClassCastException e) {
                return this.visitSymbol((Symbol)literal, context);
            }
        }

        @Override
        protected Query visitSymbol(Symbol symbol, Context context) {
            throw new UnsupportedOperationException(Symbols.format("Can't build query from symbol %s", symbol));
        }

        class AndQuery
        implements FunctionToQuery {
            AndQuery() {
            }

            @Override
            public Query apply(Function input, Context context) {
                assert (input != null) : "input must not be null";
                BooleanQuery.Builder query = new BooleanQuery.Builder();
                for (Symbol symbol : input.arguments()) {
                    query.add(symbol.accept(Visitor.this, context), BooleanClause.Occur.MUST);
                }
                return query.build();
            }
        }

        class OrQuery
        implements FunctionToQuery {
            OrQuery() {
            }

            @Override
            public Query apply(Function input, Context context) {
                assert (input != null) : "input must not be null";
                BooleanQuery.Builder query = new BooleanQuery.Builder();
                query.setMinimumNumberShouldMatch(1);
                for (Symbol symbol : input.arguments()) {
                    query.add(symbol.accept(Visitor.this, context), BooleanClause.Occur.SHOULD);
                }
                return query.build();
            }
        }

        class Ignore3vlQuery
        implements FunctionToQuery {
            Ignore3vlQuery() {
            }

            @Override
            @Nullable
            public Query apply(Function input, Context context) {
                List<Symbol> args = input.arguments();
                assert (args.size() == 1) : "ignore3vl expects exactly 1 argument, got: " + args.size();
                return args.get(0).accept(Visitor.this, context);
            }
        }
    }
}

