/*
 * Decompiled with CFR 0.152.
 */
package io.crate.lucene;

import io.crate.expression.operator.LikeOperators;
import io.crate.expression.symbol.Function;
import io.crate.lucene.FunctionToQuery;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.lucene.RefAndLiteral;
import io.crate.lucene.match.CrateRegexQuery;
import io.crate.metadata.Reference;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import javax.annotation.Nullable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.WildcardQuery;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.mapper.MappedFieldType;

final class LikeQuery
implements FunctionToQuery {
    private final boolean ignoreCase;
    private static final int CASE_INSENSITIVE = 66;

    public LikeQuery(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    @Override
    public Query apply(Function input, LuceneQueryBuilder.Context context) {
        RefAndLiteral refAndLiteral = RefAndLiteral.of(input);
        if (refAndLiteral == null) {
            return null;
        }
        return LikeQuery.toQuery(refAndLiteral.reference(), refAndLiteral.literal().value(), context, this.ignoreCase);
    }

    static Query toQuery(Reference reference, Object value, LuceneQueryBuilder.Context context, boolean ignoreCase) {
        DataType<?> dataType = ArrayType.unnest(reference.valueType());
        return LikeQuery.like(dataType, context.getFieldTypeOrNull(reference.column().fqn()), value, ignoreCase);
    }

    public static Query like(DataType dataType, @Nullable MappedFieldType fieldType, Object value, boolean ignoreCase) {
        if (fieldType == null) {
            return Queries.newMatchNoDocsQuery("column does not exist in this index");
        }
        if (dataType.equals(DataTypes.STRING)) {
            return LikeQuery.createCaseAwareQuery(fieldType.name(), BytesRefs.toString(value), ignoreCase);
        }
        return fieldType.termQuery(value, null);
    }

    private static Query createCaseAwareQuery(String fieldName, String text, boolean ignoreCase) {
        java.util.function.Function<String, String> regexTransformer = ignoreCase ? LikeOperators::patternToRegex : LikeQuery::convertSqlLikeToLuceneWildcard;
        Term term = new Term(fieldName, regexTransformer.apply(text));
        return ignoreCase ? new CrateRegexQuery(term, 66) : new WildcardQuery(term);
    }

    static String convertSqlLikeToLuceneWildcard(String wildcardString) {
        StringBuilder regex = new StringBuilder();
        boolean escaped = false;
        block7: for (char currentChar : wildcardString.toCharArray()) {
            if (!escaped && currentChar == '\\') {
                escaped = true;
                continue;
            }
            switch (currentChar) {
                case '%': {
                    regex.append(escaped ? (char)'%' : '*');
                    escaped = false;
                    continue block7;
                }
                case '_': {
                    regex.append(escaped ? (char)'_' : '?');
                    escaped = false;
                    continue block7;
                }
                default: {
                    switch (currentChar) {
                        case '*': 
                        case '?': 
                        case '\\': {
                            regex.append('\\');
                            break;
                        }
                    }
                    regex.append(currentChar);
                    escaped = false;
                }
            }
        }
        return regex.toString();
    }
}

