/*
 * Decompiled with CFR 0.152.
 */
package io.crate.lucene;

import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolType;
import io.crate.lucene.FunctionToQuery;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.Reference;
import io.crate.sql.tree.ColumnPolicy;
import io.crate.types.ArrayType;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.ExistsQueryBuilder;

class IsNullQuery
implements FunctionToQuery {
    IsNullQuery() {
    }

    @Override
    public Query apply(Function input, LuceneQueryBuilder.Context context) {
        assert (input != null) : "input must not be null";
        assert (input.arguments().size() == 1) : "function's number of arguments must be 1";
        Symbol arg = input.arguments().get(0);
        if (arg.symbolType() != SymbolType.REFERENCE) {
            return null;
        }
        Reference reference = (Reference)arg;
        String columnName = reference.column().fqn();
        if (reference.valueType() instanceof ArrayType) {
            MappedFieldType fieldType = context.getFieldTypeOrNull(columnName);
            if (fieldType != null) {
                return Queries.not(fieldType.existsQuery(context.queryShardContext));
            }
            MappedFieldType fieldNames = context.getFieldTypeOrNull("_field_names");
            if (fieldNames != null) {
                return Queries.not((Query)new ConstantScoreQuery((Query)new TermQuery(new Term("_field_names", columnName))));
            }
        }
        if (reference.columnPolicy() == ColumnPolicy.IGNORED) {
            return null;
        }
        return Queries.not(ExistsQueryBuilder.newFilter(context.queryShardContext, columnName));
    }
}

