/*
 * Decompiled with CFR 0.152.
 */
package io.crate.lucene;

import io.crate.data.Input;
import io.crate.execution.engine.fetch.ReaderContext;
import io.crate.expression.InputCondition;
import io.crate.expression.reference.doc.lucene.LuceneCollectorExpression;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.RefVisitor;
import io.crate.expression.symbol.SymbolVisitors;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;

class GenericFunctionQuery
extends Query {
    private final Function function;
    private final LuceneCollectorExpression[] expressions;
    private final Input<Boolean> condition;

    GenericFunctionQuery(Function function, Collection<? extends LuceneCollectorExpression<?>> expressions, Input<Boolean> condition) {
        this.function = function;
        this.expressions = expressions.toArray(new LuceneCollectorExpression[0]);
        this.condition = condition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GenericFunctionQuery that = (GenericFunctionQuery)((Object)o);
        return this.function.equals(that.function);
    }

    public int hashCode() {
        return this.function.hashCode();
    }

    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new Weight(this){

            public boolean isCacheable(LeafReaderContext ctx) {
                if (SymbolVisitors.any(s -> s instanceof Function && !((Function)s).isDeterministic(), GenericFunctionQuery.this.function)) {
                    return false;
                }
                ArrayList fields = new ArrayList();
                RefVisitor.visitRefs(GenericFunctionQuery.this.function, ref -> fields.add(ref.column().fqn()));
                return DocValues.isCacheable((LeafReaderContext)ctx, (String[])fields.toArray(new String[0]));
            }

            public void extractTerms(Set<Term> terms) {
            }

            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                boolean match;
                Scorer s = this.scorer(context);
                TwoPhaseIterator twoPhase = s.twoPhaseIterator();
                if (twoPhase == null) {
                    match = s.iterator().advance(doc) == doc;
                } else {
                    boolean bl = match = twoPhase.approximation().advance(doc) == doc && twoPhase.matches();
                }
                if (match) {
                    assert (s.score() == 0.0f) : "score must be 0";
                    return Explanation.match((Number)Float.valueOf(0.0f), (String)("Match on id " + doc), (Explanation[])new Explanation[0]);
                }
                return Explanation.match((Number)Float.valueOf(0.0f), (String)("No match on id " + doc), (Explanation[])new Explanation[0]);
            }

            public Scorer scorer(LeafReaderContext context) throws IOException {
                return new ConstantScoreScorer((Weight)this, 0.0f, scoreMode, (TwoPhaseIterator)GenericFunctionQuery.this.getTwoPhaseIterator(context));
            }
        };
    }

    private FilteredTwoPhaseIterator getTwoPhaseIterator(LeafReaderContext context) throws IOException {
        for (LuceneCollectorExpression expression : this.expressions) {
            expression.setNextReader(new ReaderContext(context));
        }
        return new FilteredTwoPhaseIterator(context.reader(), this.condition, this.expressions);
    }

    public String toString(String field) {
        return this.function.toString();
    }

    private static class FilteredTwoPhaseIterator
    extends TwoPhaseIterator {
        private final Input<Boolean> condition;
        private final LuceneCollectorExpression[] expressions;

        FilteredTwoPhaseIterator(LeafReader reader, Input<Boolean> condition, LuceneCollectorExpression[] expressions) {
            super(DocIdSetIterator.all((int)reader.maxDoc()));
            this.condition = condition;
            this.expressions = expressions;
        }

        public boolean matches() throws IOException {
            int doc = this.approximation.docID();
            for (LuceneCollectorExpression expression : this.expressions) {
                expression.setNextDocId(doc);
            }
            return InputCondition.matches(this.condition);
        }

        public float matchCost() {
            return 10.0f;
        }
    }
}

