/*
 * Decompiled with CFR 0.152.
 */
package io.crate.lucene;

import io.crate.data.Input;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Symbol;

class FunctionLiteralPair {
    private final String functionName;
    private final Function function;
    private final Input input;

    FunctionLiteralPair(Function outerFunction) {
        assert (outerFunction.arguments().size() == 2) : "function requires 2 arguments";
        Symbol left = outerFunction.arguments().get(0);
        Symbol right = outerFunction.arguments().get(1);
        this.functionName = outerFunction.name();
        this.function = left instanceof Function ? (Function)left : (right instanceof Function ? (Function)right : null);
        this.input = left.symbolType().isValueSymbol() ? (Input)((Object)left) : (right.symbolType().isValueSymbol() ? (Input)((Object)right) : null);
    }

    boolean isValid() {
        return this.input != null && this.function != null;
    }

    Input input() {
        return this.input;
    }

    String functionName() {
        return this.functionName;
    }
}

