/*
 * Decompiled with CFR 0.152.
 */
package io.crate.lucene;

import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.lucene.FunctionToQuery;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.lucene.RefAndLiteral;
import io.crate.metadata.Reference;
import io.crate.types.DataTypes;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.mapper.MappedFieldType;

class EqQuery
implements FunctionToQuery {
    EqQuery() {
    }

    @Override
    public Query apply(Function input, LuceneQueryBuilder.Context context) {
        RefAndLiteral refAndLiteral = RefAndLiteral.of(input);
        if (refAndLiteral == null) {
            return null;
        }
        Reference reference = refAndLiteral.reference();
        Literal literal = refAndLiteral.literal();
        String columnName = reference.column().fqn();
        MappedFieldType fieldType = context.getFieldTypeOrNull(columnName);
        if (reference.valueType().id() == 12) {
            return EqQuery.refEqObject(input, reference, (Map)literal.value(), context);
        }
        if (fieldType == null) {
            return Queries.newMatchNoDocsQuery("column does not exist in this index");
        }
        if (DataTypes.isArray(reference.valueType()) && DataTypes.isArray(literal.valueType())) {
            List values = LuceneQueryBuilder.asList(literal);
            if (values.isEmpty()) {
                return LuceneQueryBuilder.genericFunctionFilter(input, context);
            }
            Query termsQuery = LuceneQueryBuilder.termsQuery(fieldType, values, context.queryShardContext);
            BooleanQuery.Builder filterClauses = new BooleanQuery.Builder();
            filterClauses.add(termsQuery, BooleanClause.Occur.MUST);
            filterClauses.add(LuceneQueryBuilder.genericFunctionFilter(input, context), BooleanClause.Occur.MUST);
            return filterClauses.build();
        }
        return fieldType.termQuery(literal.value(), context.queryShardContext);
    }

    private static Query refEqObject(Function eq, Reference reference, Map<String, Object> value, LuceneQueryBuilder.Context context) {
        BooleanQuery.Builder boolBuilder = new BooleanQuery.Builder();
        int preFilters = 0;
        for (Map.Entry<String, Object> entry : value.entrySet()) {
            String nestedColumn = entry.getKey();
            MappedFieldType fieldType = context.getFieldTypeOrNull(reference.column().fqn() + "." + nestedColumn);
            if (fieldType == null) continue;
            ++preFilters;
            boolBuilder.add(fieldType.termQuery(entry.getValue(), context.queryShardContext), BooleanClause.Occur.MUST);
        }
        Query genericFilter = LuceneQueryBuilder.genericFunctionFilter(eq, context);
        if (preFilters == 0) {
            return genericFilter;
        }
        if (preFilters == value.size()) {
            return boolBuilder.build();
        }
        boolBuilder.add(genericFilter, BooleanClause.Occur.FILTER);
        return boolBuilder.build();
    }
}

