/*
 * Decompiled with CFR 0.152.
 */
package io.crate.lucene;

import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.lucene.FunctionLiteralPair;
import io.crate.lucene.InnerFunctionToQuery;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.lucene.RefAndLiteral;
import io.crate.types.DataTypes;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.lucene.search.Queries;
import org.locationtech.spatial4j.shape.Point;

class DistanceQuery
implements InnerFunctionToQuery {
    DistanceQuery() {
    }

    @Override
    public Query apply(Function parent, Function inner, LuceneQueryBuilder.Context context) {
        assert (inner.name().equals("distance")) : "function must be distance";
        RefAndLiteral distanceRefLiteral = RefAndLiteral.of(inner);
        if (distanceRefLiteral == null) {
            return null;
        }
        FunctionLiteralPair functionLiteralPair = new FunctionLiteralPair(parent);
        if (!functionLiteralPair.isValid()) {
            return null;
        }
        Double distance = DataTypes.DOUBLE.implicitCast(functionLiteralPair.input().value());
        String parentName = functionLiteralPair.functionName();
        Literal geoPointInput = distanceRefLiteral.literal();
        String fieldName = distanceRefLiteral.reference().column().fqn();
        Point pointValue = (Point)geoPointInput.value();
        return DistanceQuery.esV5DistanceQuery(parent, context, parentName, fieldName, distance, pointValue);
    }

    private static Query esV5DistanceQuery(Function parentFunction, LuceneQueryBuilder.Context context, String parentOperatorName, String columnName, Double distance, Point lonLat) {
        switch (parentOperatorName) {
            case "op_<=": 
            case "op_<": {
                return LatLonPoint.newDistanceQuery((String)columnName, (double)lonLat.getY(), (double)lonLat.getX(), (double)distance);
            }
            case "op_>=": {
                if (distance - 1.0E-6 <= 0.0) {
                    return Queries.newMatchAllQuery();
                }
            }
            case "op_>": {
                return Queries.not(LatLonPoint.newDistanceQuery((String)columnName, (double)lonLat.getY(), (double)lonLat.getX(), (double)distance));
            }
            case "op_=": {
                return DistanceQuery.eqDistance(parentFunction, context, columnName, distance, lonLat);
            }
        }
        return null;
    }

    private static Query eqDistance(Function parentFunction, LuceneQueryBuilder.Context context, String columnName, Double distance, Point lonLat) {
        double smallDistance = distance * 0.99;
        if (smallDistance <= 0.0) {
            return LatLonPoint.newDistanceQuery((String)columnName, (double)lonLat.getY(), (double)lonLat.getX(), (double)0.0);
        }
        Query withinSmallCircle = LatLonPoint.newDistanceQuery((String)columnName, (double)lonLat.getY(), (double)lonLat.getX(), (double)smallDistance);
        Query withinLargeCircle = LatLonPoint.newDistanceQuery((String)columnName, (double)lonLat.getY(), (double)lonLat.getX(), (double)(distance * 1.01));
        return new BooleanQuery.Builder().add(withinLargeCircle, BooleanClause.Occur.MUST).add(withinSmallCircle, BooleanClause.Occur.MUST_NOT).add(LuceneQueryBuilder.genericFunctionFilter(parentFunction, context), BooleanClause.Occur.FILTER).build();
    }
}

