/*
 * Decompiled with CFR 0.152.
 */
package io.crate.lucene;

import io.crate.common.collections.Tuple;
import io.crate.expression.symbol.Function;
import io.crate.lucene.FunctionToQuery;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.lucene.RefAndLiteral;
import java.net.InetAddress;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.index.mapper.MappedFieldType;

class CIDRRangeQuery
implements FunctionToQuery {
    CIDRRangeQuery() {
    }

    @Override
    public Query apply(Function input, LuceneQueryBuilder.Context context) {
        RefAndLiteral refAndLiteral = RefAndLiteral.of(input);
        if (refAndLiteral == null) {
            return null;
        }
        String colName = refAndLiteral.reference().column().fqn();
        MappedFieldType fieldType = context.getFieldTypeOrNull(colName);
        if (fieldType == null) {
            return Queries.newMatchNoDocsQuery("column does not exist in this index");
        }
        String cidrStr = (String)refAndLiteral.literal().value();
        Tuple<InetAddress, Integer> cidr = InetAddresses.parseCidr(cidrStr);
        return InetAddressPoint.newPrefixQuery((String)fieldType.name(), (InetAddress)cidr.v1(), (int)cidr.v2());
    }
}

