/*
 * Decompiled with CFR 0.152.
 */
package io.crate.lucene;

import io.crate.data.Input;
import io.crate.expression.operator.Operators;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Symbol;
import io.crate.lucene.InnerFunctionToQuery;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.List;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import javax.annotation.Nullable;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.mapper.MappedFieldType;

public final class ArrayLengthQuery
implements InnerFunctionToQuery {
    @Override
    @Nullable
    public Query apply(Function parent, Function arrayLength, LuceneQueryBuilder.Context context) {
        String parentName = parent.name();
        if (!Operators.COMPARISON_OPERATORS.contains(parentName)) {
            return null;
        }
        List<Symbol> parentArgs = parent.arguments();
        Symbol cmpSymbol = parentArgs.get(1);
        if (!(cmpSymbol instanceof Input)) {
            return null;
        }
        Number cmpNumber = (Number)((Input)((Object)cmpSymbol)).value();
        assert (cmpNumber != null) : "If the second argument to a cmp operator is a null literal it should normalize to null";
        List<Symbol> arrayLengthArgs = arrayLength.arguments();
        Symbol arraySymbol = arrayLengthArgs.get(0);
        if (!(arraySymbol instanceof Reference)) {
            return null;
        }
        Symbol dimensionSymbol = arrayLengthArgs.get(1);
        if (!(dimensionSymbol instanceof Input)) {
            return null;
        }
        int dimension = ((Number)((Input)((Object)dimensionSymbol)).value()).intValue();
        if (dimension != 1) {
            return null;
        }
        Reference arrayRef = (Reference)arraySymbol;
        DataType<?> elementType = ArrayType.unnest(arrayRef.valueType());
        if (elementType.id() == 12 || elementType.equals(DataTypes.GEO_SHAPE)) {
            return null;
        }
        int cmpVal = cmpNumber.intValue();
        IntPredicate valueCountIsMatch = ArrayLengthQuery.predicateForFunction(parentName, cmpVal);
        switch (parentName) {
            case "op_=": {
                if (cmpVal == 0) {
                    return Queries.newMatchNoDocsQuery("array_length([], 1) is NULL, so array_length([], 1) = 0 can't match");
                }
                return ArrayLengthQuery.genericAndDocValueCount(parent, context, arrayRef, valueCountIsMatch);
            }
            case "op_>": {
                if (cmpVal == 0) {
                    return ArrayLengthQuery.existsQuery(context, arrayRef);
                }
                return ArrayLengthQuery.genericAndDocValueCount(parent, context, arrayRef, valueCountIsMatch);
            }
            case "op_>=": {
                if (cmpVal == 0) {
                    return ArrayLengthQuery.existsQuery(context, arrayRef);
                }
                if (cmpVal == 1) {
                    return ArrayLengthQuery.numTermsPerDocQuery(arrayRef, valueCountIsMatch);
                }
                return LuceneQueryBuilder.genericFunctionFilter(parent, context);
            }
            case "op_<": {
                if (cmpVal == 0 || cmpVal == 1) {
                    return Queries.newMatchNoDocsQuery("array_length([], 1) is NULL, so array_length([], 1) < 0 or < 1 can't match");
                }
                return ArrayLengthQuery.genericAndDocValueCount(parent, context, arrayRef, valueCountIsMatch);
            }
            case "op_<=": {
                if (cmpVal == 0) {
                    return Queries.newMatchNoDocsQuery("array_length([], 1) is NULL, so array_length([], 1) <= 0 can't match");
                }
                return ArrayLengthQuery.genericAndDocValueCount(parent, context, arrayRef, valueCountIsMatch);
            }
        }
        throw new IllegalArgumentException("Illegal operator: " + parentName);
    }

    private static Query genericAndDocValueCount(Function parent, LuceneQueryBuilder.Context context, Reference arrayRef, IntPredicate valueCountIsMatch) {
        return new BooleanQuery.Builder().add((Query)ArrayLengthQuery.numTermsPerDocQuery(arrayRef, valueCountIsMatch), BooleanClause.Occur.MUST).add(LuceneQueryBuilder.genericFunctionFilter(parent, context), BooleanClause.Occur.FILTER).build();
    }

    private static NumTermsPerDocQuery numTermsPerDocQuery(Reference arrayRef, IntPredicate valueCountIsMatch) {
        return new NumTermsPerDocQuery(arrayRef.column().fqn(), leafReaderContext -> ArrayLengthQuery.getNumTermsPerDocFunction(leafReaderContext.reader(), arrayRef), valueCountIsMatch);
    }

    private static Query existsQuery(LuceneQueryBuilder.Context context, Reference arrayRef) {
        MappedFieldType fieldType = context.getFieldTypeOrNull(arrayRef.column().fqn());
        if (fieldType == null) {
            return Queries.newMatchNoDocsQuery("MappedFieldType missing");
        }
        return fieldType.existsQuery(context.queryShardContext());
    }

    private static IntPredicate predicateForFunction(String cmpFuncName, int cmpValue) {
        switch (cmpFuncName) {
            case "op_<": {
                return x -> x < cmpValue;
            }
            case "op_<=": {
                return x -> x <= cmpValue;
            }
            case "op_>": {
                return x -> x > cmpValue;
            }
            case "op_>=": {
                return x -> x >= cmpValue;
            }
            case "op_=": {
                return x -> x == cmpValue;
            }
        }
        throw new IllegalArgumentException("Unknown comparison function: " + cmpFuncName);
    }

    private static IntUnaryOperator getNumTermsPerDocFunction(LeafReader reader, Reference ref) {
        DataType<?> elementType = ArrayType.unnest(ref.valueType());
        switch (elementType.id()) {
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                return ArrayLengthQuery.numValuesPerDocForSortedNumeric(reader, ref.column());
            }
            case 4: {
                return ArrayLengthQuery.numValuesPerDocForString(reader, ref.column());
            }
            case 5: {
                return ArrayLengthQuery.numValuesPerDocForIP(reader, ref.column());
            }
        }
        throw new UnsupportedOperationException("NYI: " + elementType);
    }

    private static IntUnaryOperator numValuesPerDocForIP(LeafReader reader, ColumnIdent column) {
        SortedSetDocValues docValues;
        try {
            docValues = reader.getSortedSetDocValues(column.fqn());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return doc -> {
            try {
                if (docValues.advanceExact(doc)) {
                    int c = 1;
                    while (docValues.nextOrd() != -1L) {
                        ++c;
                    }
                    return c;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return 0;
        };
    }

    private static IntUnaryOperator numValuesPerDocForString(LeafReader reader, ColumnIdent column) {
        SortedBinaryDocValues docValues;
        try {
            docValues = FieldData.toString(DocValues.getSortedSet((LeafReader)reader, (String)column.fqn()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return doc -> {
            try {
                return docValues.advanceExact(doc) ? docValues.docValueCount() : 0;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    private static IntUnaryOperator numValuesPerDocForSortedNumeric(LeafReader reader, ColumnIdent column) {
        SortedNumericDocValues sortedNumeric;
        try {
            sortedNumeric = DocValues.getSortedNumeric((LeafReader)reader, (String)column.fqn());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return doc -> {
            try {
                return sortedNumeric.advanceExact(doc) ? sortedNumeric.docValueCount() : 0;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    static class NumTermsPerDocQuery
    extends Query {
        private final String column;
        private final java.util.function.Function<LeafReaderContext, IntUnaryOperator> numTermsPerDocFactory;
        private final IntPredicate matches;

        NumTermsPerDocQuery(String column, java.util.function.Function<LeafReaderContext, IntUnaryOperator> numTermsPerDocFactory, IntPredicate matches) {
            this.column = column;
            this.numTermsPerDocFactory = numTermsPerDocFactory;
            this.matches = matches;
        }

        public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
            return new ConstantScoreWeight(this, boost){

                public boolean isCacheable(LeafReaderContext ctx) {
                    return false;
                }

                public Scorer scorer(LeafReaderContext context) {
                    return new ConstantScoreScorer((Weight)this, 0.0f, scoreMode, (TwoPhaseIterator)new NumTermsPerDocTwoPhaseIterator(context.reader(), numTermsPerDocFactory.apply(context), matches));
                }
            };
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            NumTermsPerDocQuery that = (NumTermsPerDocQuery)((Object)o);
            if (!this.numTermsPerDocFactory.equals(that.numTermsPerDocFactory)) {
                return false;
            }
            return this.matches.equals(that.matches);
        }

        public int hashCode() {
            int result = this.numTermsPerDocFactory.hashCode();
            result = 31 * result + this.matches.hashCode();
            return result;
        }

        public String toString(String field) {
            return "NumTermsPerDoc: " + this.column;
        }
    }

    private static class NumTermsPerDocTwoPhaseIterator
    extends TwoPhaseIterator {
        private final IntUnaryOperator numTermsOfDoc;
        private final IntPredicate matches;

        NumTermsPerDocTwoPhaseIterator(LeafReader reader, IntUnaryOperator numTermsOfDoc, IntPredicate matches) {
            super(DocIdSetIterator.all((int)reader.maxDoc()));
            this.numTermsOfDoc = numTermsOfDoc;
            this.matches = matches;
        }

        public boolean matches() {
            int doc = this.approximation.docID();
            return this.matches.test(this.numTermsOfDoc.applyAsInt(doc));
        }

        public float matchCost() {
            return 2.0f;
        }
    }
}

