/*
 * Decompiled with CFR 0.152.
 */
package io.crate.lucene;

import io.crate.expression.symbol.Literal;
import io.crate.lucene.AbstractAnyQuery;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.lucene.RangeQuery;
import io.crate.metadata.Reference;
import java.io.IOException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;

class AnyRangeQuery
extends AbstractAnyQuery {
    private final RangeQuery rangeQuery;
    private final RangeQuery inverseRangeQuery;

    AnyRangeQuery(String comparison, String inverseComparison) {
        this.rangeQuery = new RangeQuery(comparison);
        this.inverseRangeQuery = new RangeQuery(inverseComparison);
    }

    protected Query literalMatchesAnyArrayRef(Literal candidate, Reference array, LuceneQueryBuilder.Context context) throws IOException {
        return this.rangeQuery.toQuery(array, candidate.value(), context::getFieldTypeOrNull, context.queryShardContext);
    }

    protected Query refMatchesAnyArrayLiteral(Reference candidate, Literal array, LuceneQueryBuilder.Context context) {
        BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder();
        booleanQuery.setMinimumNumberShouldMatch(1);
        for (Object value : AnyRangeQuery.toIterable(array.value())) {
            booleanQuery.add(this.inverseRangeQuery.toQuery(candidate, value, context::getFieldTypeOrNull, context.queryShardContext), BooleanClause.Occur.SHOULD);
        }
        return booleanQuery.build();
    }
}

