/*
 * Decompiled with CFR 0.152.
 */
package io.crate.lucene;

import io.crate.expression.operator.LikeOperators;
import io.crate.expression.symbol.Literal;
import io.crate.lucene.AbstractAnyQuery;
import io.crate.lucene.LikeQuery;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.Reference;
import java.io.IOException;
import java.util.Locale;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.RegexpFlag;

class AnyNotLikeQuery
extends AbstractAnyQuery {
    private static String negateWildcard(String wildCard) {
        return String.format(Locale.ENGLISH, "~(%s)", wildCard);
    }

    AnyNotLikeQuery(boolean ignoreCase) {
        super(ignoreCase);
    }

    protected Query literalMatchesAnyArrayRef(Literal candidate, Reference array, LuceneQueryBuilder.Context context) throws IOException {
        String regexString = LikeOperators.patternToRegex((String)candidate.value(), '\\', false);
        regexString = regexString.substring(1, regexString.length() - 1);
        String notLike = AnyNotLikeQuery.negateWildcard(regexString);
        return new RegexpQuery(new Term(array.column().fqn(), notLike), RegexpFlag.COMPLEMENT.value());
    }

    protected Query refMatchesAnyArrayLiteral(Reference candidate, Literal array, LuceneQueryBuilder.Context context) {
        String columnName = candidate.column().fqn();
        MappedFieldType fieldType = context.getFieldTypeOrNull(columnName);
        BooleanQuery.Builder andLikeQueries = new BooleanQuery.Builder();
        for (Object value : AnyNotLikeQuery.toIterable(array.value())) {
            andLikeQueries.add(LikeQuery.like(candidate.valueType(), fieldType, value, this.ignoreCase), BooleanClause.Occur.MUST);
        }
        return Queries.not((Query)andLikeQueries.build());
    }
}

