/*
 * Decompiled with CFR 0.152.
 */
package io.crate.lucene;

import io.crate.expression.symbol.Literal;
import io.crate.lucene.AbstractAnyQuery;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.Reference;
import java.io.IOException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.mapper.MappedFieldType;

class AnyNeqQuery
extends AbstractAnyQuery {
    AnyNeqQuery() {
    }

    protected Query literalMatchesAnyArrayRef(Literal candidate, Reference array, LuceneQueryBuilder.Context context) throws IOException {
        String columnName = array.column().fqn();
        Object value = candidate.value();
        MappedFieldType fieldType = context.getFieldTypeOrNull(columnName);
        if (fieldType == null) {
            return Queries.newMatchNoDocsQuery("column does not exist in this index");
        }
        BooleanQuery.Builder query = new BooleanQuery.Builder();
        query.setMinimumNumberShouldMatch(1);
        query.add(fieldType.rangeQuery(value, null, false, false, null, null, context.queryShardContext), BooleanClause.Occur.SHOULD);
        query.add(fieldType.rangeQuery(null, value, false, false, null, null, context.queryShardContext), BooleanClause.Occur.SHOULD);
        return query.build();
    }

    protected Query refMatchesAnyArrayLiteral(Reference candidate, Literal array, LuceneQueryBuilder.Context context) {
        String columnName = candidate.column().fqn();
        MappedFieldType fieldType = context.getFieldTypeOrNull(columnName);
        if (fieldType == null) {
            return Queries.newMatchNoDocsQuery("column does not exist in this index");
        }
        BooleanQuery.Builder andBuilder = new BooleanQuery.Builder();
        for (Object value : AnyNeqQuery.toIterable(array.value())) {
            andBuilder.add(fieldType.termQuery(value, context.queryShardContext()), BooleanClause.Occur.MUST);
        }
        return Queries.not((Query)andBuilder.build());
    }
}

