/*
 * Decompiled with CFR 0.152.
 */
package io.crate.lucene;

import io.crate.expression.symbol.Literal;
import io.crate.lucene.AbstractAnyQuery;
import io.crate.lucene.LikeQuery;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.Reference;
import java.io.IOException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;

class AnyLikeQuery
extends AbstractAnyQuery {
    AnyLikeQuery(boolean ignoreCase) {
        super(ignoreCase);
    }

    protected Query literalMatchesAnyArrayRef(Literal candidate, Reference array, LuceneQueryBuilder.Context context) throws IOException {
        return LikeQuery.toQuery(array, candidate.value(), context, this.ignoreCase);
    }

    protected Query refMatchesAnyArrayLiteral(Reference candidate, Literal array, LuceneQueryBuilder.Context context) {
        BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder();
        booleanQuery.setMinimumNumberShouldMatch(1);
        for (Object value : AnyLikeQuery.toIterable(array.value())) {
            booleanQuery.add(LikeQuery.toQuery(candidate, value, context, this.ignoreCase), BooleanClause.Occur.SHOULD);
        }
        return booleanQuery.build();
    }
}

