/*
 * Decompiled with CFR 0.152.
 */
package io.crate.lucene;

import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.lucene.AbstractAnyQuery;
import io.crate.lucene.FunctionToQuery;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.Reference;
import io.crate.types.ArrayType;
import io.crate.types.DataTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.mapper.MappedFieldType;

class AnyEqQuery
implements FunctionToQuery {
    AnyEqQuery() {
    }

    @Override
    @Nullable
    public Query apply(Function input, LuceneQueryBuilder.Context context) {
        List<Symbol> args = input.arguments();
        Symbol candidate = args.get(0);
        Symbol array = args.get(1);
        if (candidate instanceof Literal && array instanceof Reference) {
            return AnyEqQuery.literalMatchesAnyArrayRef(input, (Literal)candidate, (Reference)array, context);
        }
        if (candidate instanceof Reference && array instanceof Literal) {
            return AnyEqQuery.refMatchesAnyArrayLiteral((Reference)candidate, (Literal)array, context);
        }
        return LuceneQueryBuilder.genericFunctionFilter(input, context);
    }

    private static Query literalMatchesAnyArrayRef(Function any, Literal candidate, Reference array, LuceneQueryBuilder.Context context) {
        MappedFieldType fieldType = context.getFieldTypeOrNull(array.column().fqn());
        if (fieldType == null) {
            if (ArrayType.unnest(array.valueType()).id() == 12) {
                return LuceneQueryBuilder.genericFunctionFilter(any, context);
            }
            return Queries.newMatchNoDocsQuery("column doesn't exist in this index");
        }
        if (DataTypes.isArray(candidate.valueType())) {
            return AnyEqQuery.arrayLiteralEqAnyArray(any, fieldType, candidate.value(), context);
        }
        return fieldType.termQuery(candidate.value(), context.queryShardContext());
    }

    private static Query refMatchesAnyArrayLiteral(Reference candidate, Literal array, LuceneQueryBuilder.Context context) {
        String columnName = candidate.column().fqn();
        return LuceneQueryBuilder.termsQuery(context.getFieldTypeOrNull(columnName), LuceneQueryBuilder.asList(array), context.queryShardContext);
    }

    private static Query arrayLiteralEqAnyArray(Function function, MappedFieldType fieldType, Object candidate, LuceneQueryBuilder.Context context) {
        ArrayList terms = new ArrayList();
        AnyEqQuery.gatherLeafs(AbstractAnyQuery.toIterable(candidate), terms::add);
        return new BooleanQuery.Builder().add(fieldType.termsQuery(terms, context.queryShardContext), BooleanClause.Occur.MUST).add(LuceneQueryBuilder.genericFunctionFilter(function, context), BooleanClause.Occur.FILTER).build();
    }

    private static void gatherLeafs(Iterable<?> toIterable, Consumer<? super Object> consumeLeaf) {
        for (Object o : toIterable) {
            if (o instanceof Iterable) {
                AnyEqQuery.gatherLeafs((Iterable)o, consumeLeaf);
                continue;
            }
            if (o instanceof Object[]) {
                AnyEqQuery.gatherLeafs(Arrays.asList((Object[])o), consumeLeaf);
                continue;
            }
            consumeLeaf.accept(o);
        }
    }
}

