/*
 * Decompiled with CFR 0.152.
 */
package io.crate.lucene;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import io.crate.exceptions.UnsupportedFeatureException;
import io.crate.expression.operator.any.AnyOperators;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.lucene.FunctionToQuery;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.Reference;
import io.crate.types.DataTypes;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;

abstract class AbstractAnyQuery
implements FunctionToQuery {
    protected boolean ignoreCase;

    AbstractAnyQuery() {
        this(false);
    }

    AbstractAnyQuery(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    @Override
    public Query apply(io.crate.expression.symbol.Function function, LuceneQueryBuilder.Context context) throws IOException {
        Symbol left = function.arguments().get(0);
        Symbol collectionSymbol = function.arguments().get(1);
        if (!DataTypes.isArray(collectionSymbol.valueType())) {
            throw new IllegalArgumentException("invalid argument for ANY expression");
        }
        if (DataTypes.isArray(left.valueType())) {
            throw new UnsupportedFeatureException("Cannot use " + function.name() + " when the left side is an array");
        }
        if (left.symbolType().isValueSymbol()) {
            if (collectionSymbol instanceof Reference) {
                return this.literalMatchesAnyArrayRef((Literal)left, (Reference)collectionSymbol, context);
            }
            return null;
        }
        if (left instanceof Reference && collectionSymbol.symbolType().isValueSymbol()) {
            return this.refMatchesAnyArrayLiteral((Reference)left, (Literal)collectionSymbol, context);
        }
        return null;
    }

    static Iterable<?> toIterable(Object value) {
        return Iterables.transform(AnyOperators.collectionValueToIterable(value), (Function)new Function<Object, Object>(){

            @Nullable
            public Object apply(@Nullable Object input) {
                if (input instanceof String) {
                    input = new BytesRef((CharSequence)((String)input));
                }
                return input;
            }
        });
    }

    protected abstract Query literalMatchesAnyArrayRef(Literal<?> var1, Reference var2, LuceneQueryBuilder.Context var3) throws IOException;

    protected abstract Query refMatchesAnyArrayLiteral(Reference var1, Literal<?> var2, LuceneQueryBuilder.Context var3) throws IOException;
}

