/*
 * Decompiled with CFR 0.152.
 */
package io.crate.license;

import io.crate.license.LicenseData;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.elasticsearch.cluster.ClusterStateListener;

public interface LicenseService {
    public static final String LICENSE_IS_LOADING = "License is loading";

    public CompletableFuture<Long> registerLicense(String var1);

    public LicenseState getLicenseState();

    @Nullable
    public LicenseData currentLicense();

    @Nullable
    public ClusterStateListener clusterStateListener();

    default public Mode getMode() {
        return Mode.CE;
    }

    @Nullable
    default public Long getExpiryDateInMs() {
        LicenseData currentLicense = this.currentLicense();
        if (currentLicense == null) {
            return null;
        }
        long expiryDateInMs = currentLicense.expiryDateInMs();
        return expiryDateInMs == Long.MAX_VALUE ? null : Long.valueOf(expiryDateInMs);
    }

    @Nullable
    default public String getIssuedTo() {
        LicenseData currentLicense = this.currentLicense();
        if (currentLicense != null) {
            return currentLicense.issuedTo();
        }
        if (this.getMode() == Mode.ENTERPRISE) {
            return LICENSE_IS_LOADING;
        }
        return null;
    }

    @Nullable
    default public Integer getMaxNodes() {
        LicenseData currentLicense = this.currentLicense();
        if (currentLicense == null) {
            return null;
        }
        return currentLicense.maxNumberOfNodes();
    }

    public static enum Mode {
        CE,
        ENTERPRISE;

    }

    public static enum LicenseState {
        VALID,
        EXPIRED,
        MAX_NODES_VIOLATED;

    }
}

