/*
 * Decompiled with CFR 0.152.
 */
package io.crate.license;

import java.util.Objects;

public class LicenseData {
    private final long expiryDateInMs;
    private final String issuedTo;
    private final int maxNumberOfNodes;

    public LicenseData(long expiryDateInMs, String issuedTo, int maxNumberOfNodes) {
        this.expiryDateInMs = expiryDateInMs;
        this.issuedTo = issuedTo;
        this.maxNumberOfNodes = maxNumberOfNodes;
    }

    public long expiryDateInMs() {
        return this.expiryDateInMs;
    }

    public long millisToExpiration() {
        return this.expiryDateInMs - System.currentTimeMillis();
    }

    public String issuedTo() {
        return this.issuedTo;
    }

    public int maxNumberOfNodes() {
        return this.maxNumberOfNodes;
    }

    boolean isExpired() {
        return this.millisToExpiration() < 0L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LicenseData that = (LicenseData)o;
        return this.expiryDateInMs == that.expiryDateInMs && this.maxNumberOfNodes == that.maxNumberOfNodes && Objects.equals(this.issuedTo, that.issuedTo);
    }

    public int hashCode() {
        return Objects.hash(this.expiryDateInMs, this.issuedTo, this.maxNumberOfNodes);
    }
}

