/*
 * Decompiled with CFR 0.152.
 */
package io.crate.interval;

import io.crate.interval.IntervalParser;
import java.math.BigDecimal;
import java.util.StringTokenizer;
import javax.annotation.Nullable;
import org.joda.time.Period;

final class PGIntervalParser {
    PGIntervalParser() {
    }

    static Period apply(String value, @Nullable IntervalParser.Precision start, @Nullable IntervalParser.Precision end) {
        return IntervalParser.roundToPrecision(PGIntervalParser.apply(value), start, end);
    }

    static Period apply(String value) {
        boolean ISOFormat;
        boolean bl = ISOFormat = !value.startsWith("@");
        if (!ISOFormat && value.length() == 3 && value.charAt(2) == '0') {
            return new Period();
        }
        boolean dataParsed = false;
        int years = 0;
        int months = 0;
        int days = 0;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        int milliSeconds = 0;
        try {
            String valueToken = null;
            value = value.replace('+', ' ').replace('@', ' ');
            StringTokenizer st = new StringTokenizer(value);
            int i = 1;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (i & true) {
                    int endHours = token.indexOf(58);
                    if (endHours == -1) {
                        valueToken = token;
                    } else {
                        int offset = token.charAt(0) == '-' ? 1 : 0;
                        hours = IntervalParser.nullSafeIntGet(token.substring(offset, endHours));
                        minutes = IntervalParser.nullSafeIntGet(token.substring(endHours + 1, endHours + 3));
                        int endMinutes = token.indexOf(58, endHours + 1);
                        seconds = PGIntervalParser.parseInteger(token.substring(endMinutes + 1));
                        milliSeconds = IntervalParser.parseMilliSeconds(token.substring(endMinutes + 1));
                        if (offset == 1) {
                            hours = -hours;
                            minutes = -minutes;
                            seconds = -seconds;
                            milliSeconds = -milliSeconds;
                        }
                        valueToken = null;
                    }
                } else {
                    if (token.startsWith("year")) {
                        years = IntervalParser.nullSafeIntGet(valueToken);
                    } else if (token.startsWith("mon")) {
                        months = IntervalParser.nullSafeIntGet(valueToken);
                    } else if (token.startsWith("day")) {
                        days = IntervalParser.nullSafeIntGet(valueToken);
                    } else if (token.startsWith("week")) {
                        days = IntervalParser.nullSafeIntGet(valueToken) * 7;
                    } else if (token.startsWith("hour")) {
                        hours = IntervalParser.nullSafeIntGet(valueToken);
                    } else if (token.startsWith("min")) {
                        minutes = IntervalParser.nullSafeIntGet(valueToken);
                    } else if (token.startsWith("sec")) {
                        seconds = PGIntervalParser.parseInteger(valueToken);
                        milliSeconds = IntervalParser.parseMilliSeconds(valueToken);
                    } else {
                        throw new IllegalArgumentException("Invalid interval format " + value);
                    }
                    dataParsed = true;
                }
                ++i;
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid interval format " + value);
        }
        if (!dataParsed) {
            throw new IllegalArgumentException("Invalid interval format " + value);
        }
        Period period = new Period(years, months, 0, days, hours, minutes, seconds, milliSeconds);
        if (!ISOFormat && value.endsWith("ago")) {
            period = period.negated();
        }
        return period;
    }

    private static int parseInteger(String value) {
        return new BigDecimal(value).intValue();
    }
}

