/*
 * Decompiled with CFR 0.152.
 */
package io.crate.external;

import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSCredentialsProviderChain;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.EnvironmentVariableCredentialsProvider;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.auth.SystemPropertiesCredentialsProvider;
import com.amazonaws.retry.PredefinedRetryPolicies;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.IntObjectMap;
import java.io.IOException;
import java.net.URI;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class S3ClientHelper {
    private static final AWSCredentialsProvider DEFAULT_CREDENTIALS_PROVIDER_CHAIN = new AWSCredentialsProviderChain(new AWSCredentialsProvider[]{new EnvironmentVariableCredentialsProvider(), new SystemPropertiesCredentialsProvider(), new InstanceProfileCredentialsProvider()}){
        private AWSCredentials ANONYMOUS_CREDENTIALS = new AnonymousAWSCredentials();

        public AWSCredentials getCredentials() {
            try {
                return super.getCredentials();
            }
            catch (AmazonClientException ace) {
                return this.ANONYMOUS_CREDENTIALS;
            }
        }
    };
    private static final ClientConfiguration CLIENT_CONFIGURATION = new ClientConfiguration().withProtocol(Protocol.HTTPS);
    private static final String INVALID_URI_MSG = "Invalid URI. Please make sure that given URI is encoded properly.";
    private final IntObjectMap<AmazonS3> clientMap = new IntObjectHashMap(1);

    protected AmazonS3 initClient(@Nullable String accessKey, @Nullable String secretKey) throws IOException {
        if (accessKey == null || secretKey == null) {
            return new AmazonS3Client(DEFAULT_CREDENTIALS_PROVIDER_CHAIN, CLIENT_CONFIGURATION);
        }
        return new AmazonS3Client((AWSCredentials)new BasicAWSCredentials(accessKey, secretKey), CLIENT_CONFIGURATION);
    }

    public AmazonS3 client(URI uri) throws IOException {
        String accessKey = null;
        String secretKey = null;
        if (uri.getHost() == null) {
            throw new IllegalArgumentException(INVALID_URI_MSG);
        }
        if (uri.getUserInfo() != null) {
            String[] userInfoParts = uri.getUserInfo().split(":");
            try {
                accessKey = userInfoParts[0];
                secretKey = userInfoParts[1];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        } else if (uri.toString().contains("@") && uri.toString().contains(":")) {
            throw new IllegalArgumentException(INVALID_URI_MSG);
        }
        return this.client(accessKey, secretKey);
    }

    private AmazonS3 client(@Nullable String accessKey, @Nullable String secretKey) throws IOException {
        int hash = S3ClientHelper.hash(accessKey, secretKey);
        AmazonS3 client = (AmazonS3)this.clientMap.get(hash);
        if (client == null) {
            client = this.initClient(accessKey, secretKey);
            this.clientMap.put(hash, (Object)client);
        }
        return client;
    }

    private static int hash(@Nullable String accessKey, @Nullable String secretKey) {
        return 31 * (accessKey == null ? 1 : accessKey.hashCode()) + (secretKey == null ? 1 : secretKey.hashCode());
    }

    static {
        CLIENT_CONFIGURATION.setRetryPolicy(PredefinedRetryPolicies.getDefaultRetryPolicyWithCustomMaxRetries((int)5));
        CLIENT_CONFIGURATION.setUseTcpKeepAlive(true);
    }
}

