/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.udf;

import io.crate.common.annotations.VisibleForTesting;
import io.crate.expression.udf.UserDefinedFunctionMetadata;
import io.crate.types.DataType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class UserDefinedFunctionsMetadata
extends AbstractNamedDiffable<Metadata.Custom>
implements Metadata.Custom {
    public static final String TYPE = "user_defined_functions";
    private final List<UserDefinedFunctionMetadata> functionsMetadata;

    private UserDefinedFunctionsMetadata(List<UserDefinedFunctionMetadata> functions) {
        this.functionsMetadata = functions;
    }

    public static UserDefinedFunctionsMetadata newInstance(UserDefinedFunctionsMetadata instance) {
        return new UserDefinedFunctionsMetadata(new ArrayList<UserDefinedFunctionMetadata>(instance.functionsMetadata));
    }

    @VisibleForTesting
    public static UserDefinedFunctionsMetadata of(UserDefinedFunctionMetadata ... functions) {
        return new UserDefinedFunctionsMetadata(Arrays.asList(functions));
    }

    public void add(UserDefinedFunctionMetadata function) {
        this.functionsMetadata.add(function);
    }

    public void replace(UserDefinedFunctionMetadata function) {
        for (int i = 0; i < this.functionsMetadata.size(); ++i) {
            if (!this.functionsMetadata.get(i).sameSignature(function.schema(), function.name(), function.argumentTypes())) continue;
            this.functionsMetadata.set(i, function);
        }
    }

    public boolean contains(String schema, String name, List<DataType<?>> types) {
        for (UserDefinedFunctionMetadata function : this.functionsMetadata) {
            if (!function.sameSignature(schema, name, types)) continue;
            return true;
        }
        return false;
    }

    public void remove(String schema, String name, List<DataType<?>> types) {
        ListIterator<UserDefinedFunctionMetadata> iter = this.functionsMetadata.listIterator();
        while (iter.hasNext()) {
            if (!iter.next().sameSignature(schema, name, types)) continue;
            iter.remove();
        }
    }

    public List<UserDefinedFunctionMetadata> functionsMetadata() {
        return this.functionsMetadata;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.functionsMetadata.size());
        for (UserDefinedFunctionMetadata function : this.functionsMetadata) {
            function.writeTo(out);
        }
    }

    public UserDefinedFunctionsMetadata(StreamInput in) throws IOException {
        int size = in.readVInt();
        ArrayList<UserDefinedFunctionMetadata> functions = new ArrayList<UserDefinedFunctionMetadata>(size);
        for (int i = 0; i < size; ++i) {
            functions.add(new UserDefinedFunctionMetadata(in));
        }
        this.functionsMetadata = functions;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray("functions");
        for (UserDefinedFunctionMetadata function : this.functionsMetadata) {
            function.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    public static UserDefinedFunctionsMetadata fromXContent(XContentParser parser) throws IOException {
        ArrayList<UserDefinedFunctionMetadata> functions = new ArrayList<UserDefinedFunctionMetadata>();
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            if (parser.currentToken() != XContentParser.Token.FIELD_NAME || !Objects.equals(parser.currentName(), "functions") || parser.nextToken() != XContentParser.Token.START_ARRAY) continue;
            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                functions.add(UserDefinedFunctionMetadata.fromXContent(parser));
            }
        }
        return new UserDefinedFunctionsMetadata(functions);
    }

    @Override
    public EnumSet<Metadata.XContentContext> context() {
        return EnumSet.of(Metadata.XContentContext.GATEWAY, Metadata.XContentContext.SNAPSHOT);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserDefinedFunctionsMetadata that = (UserDefinedFunctionsMetadata)o;
        return this.functionsMetadata.equals(that.functionsMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.functionsMetadata);
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return Version.V_3_0_1;
    }
}

