/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.udf;

import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.analyze.expressions.TableReferenceResolver;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.common.collections.Lists2;
import io.crate.common.unit.TimeValue;
import io.crate.exceptions.UserDefinedFunctionAlreadyExistsException;
import io.crate.exceptions.UserDefinedFunctionUnknownException;
import io.crate.expression.udf.UDFLanguage;
import io.crate.expression.udf.UserDefinedFunctionMetadata;
import io.crate.expression.udf.UserDefinedFunctionsMetadata;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.FunctionName;
import io.crate.metadata.FunctionProvider;
import io.crate.metadata.FunctionType;
import io.crate.metadata.GeneratedReference;
import io.crate.metadata.IndexParts;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.Scalar;
import io.crate.metadata.doc.DocSchemaInfo;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.doc.DocTableInfoBuilder;
import io.crate.metadata.functions.Signature;
import io.crate.sql.parser.SqlParser;
import io.crate.sql.tree.Expression;
import io.crate.types.DataType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.script.ScriptException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;

@Singleton
public class UserDefinedFunctionService {
    private static final Logger LOGGER = LogManager.getLogger(UserDefinedFunctionService.class);
    private final ClusterService clusterService;
    private final NodeContext nodeCtx;
    private final Map<String, UDFLanguage> languageRegistry = new HashMap<String, UDFLanguage>();

    @Inject
    public UserDefinedFunctionService(ClusterService clusterService, NodeContext nodeCtx) {
        this.clusterService = clusterService;
        this.nodeCtx = nodeCtx;
    }

    public UDFLanguage getLanguage(String languageName) throws IllegalArgumentException {
        UDFLanguage lang = this.languageRegistry.get(languageName);
        if (lang == null) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "'%s' is not a valid UDF language", languageName));
        }
        return lang;
    }

    public void registerLanguage(UDFLanguage language) {
        this.languageRegistry.put(language.name(), language);
    }

    void registerFunction(final UserDefinedFunctionMetadata metadata, final boolean replace, final ActionListener<AcknowledgedResponse> listener, final TimeValue timeout) {
        this.clusterService.submitStateUpdateTask("put_udf [" + metadata.name() + "]", new ClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                Metadata currentMetadata = currentState.metadata();
                Metadata.Builder mdBuilder = Metadata.builder(currentMetadata);
                UserDefinedFunctionsMetadata functions = UserDefinedFunctionService.this.putFunction((UserDefinedFunctionsMetadata)currentMetadata.custom("user_defined_functions"), metadata, replace);
                mdBuilder.putCustom("user_defined_functions", functions);
                return ClusterState.builder(currentState).metadata(mdBuilder).build();
            }

            @Override
            public TimeValue timeout() {
                return timeout;
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse(new AcknowledgedResponse(true));
            }

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }
        });
    }

    void dropFunction(final String schema, final String name, final List<DataType<?>> argumentTypes, final boolean ifExists, final ActionListener<AcknowledgedResponse> listener, final TimeValue timeout) {
        this.clusterService.submitStateUpdateTask("drop_udf [" + schema + "." + name + " - " + argumentTypes + "]", new ClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                Metadata metadata = currentState.metadata();
                Metadata.Builder mdBuilder = Metadata.builder(currentState.metadata());
                UserDefinedFunctionsMetadata functions = UserDefinedFunctionService.this.removeFunction((UserDefinedFunctionsMetadata)metadata.custom("user_defined_functions"), schema, name, argumentTypes, ifExists);
                mdBuilder.putCustom("user_defined_functions", functions);
                UserDefinedFunctionService.this.validateFunctionIsNotInUseByGeneratedColumn(schema, schema + "." + UserDefinedFunctionMetadata.specificName(name, argumentTypes), functions, currentState);
                return ClusterState.builder(currentState).metadata(mdBuilder).build();
            }

            @Override
            public TimeValue timeout() {
                return timeout;
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse(new AcknowledgedResponse(true));
            }

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }
        });
    }

    @VisibleForTesting
    UserDefinedFunctionsMetadata putFunction(@Nullable UserDefinedFunctionsMetadata oldMetadata, UserDefinedFunctionMetadata functionMetadata, boolean replace) {
        if (oldMetadata == null) {
            return UserDefinedFunctionsMetadata.of(functionMetadata);
        }
        UserDefinedFunctionsMetadata newMetadata = UserDefinedFunctionsMetadata.newInstance(oldMetadata);
        if (oldMetadata.contains(functionMetadata.schema(), functionMetadata.name(), functionMetadata.argumentTypes())) {
            if (!replace) {
                throw new UserDefinedFunctionAlreadyExistsException(functionMetadata);
            }
            newMetadata.replace(functionMetadata);
        } else {
            newMetadata.add(functionMetadata);
        }
        assert (!newMetadata.equals(oldMetadata)) : "must not be equal to guarantee the cluster change action";
        return newMetadata;
    }

    @VisibleForTesting
    UserDefinedFunctionsMetadata removeFunction(@Nullable UserDefinedFunctionsMetadata functions, String schema, String name, List<DataType<?>> argumentDataTypes, boolean ifExists) {
        if (!(ifExists || functions != null && functions.contains(schema, name, argumentDataTypes))) {
            throw new UserDefinedFunctionUnknownException(schema, name, argumentDataTypes);
        }
        if (functions == null) {
            return UserDefinedFunctionsMetadata.of(new UserDefinedFunctionMetadata[0]);
        }
        UserDefinedFunctionsMetadata newMetadata = UserDefinedFunctionsMetadata.newInstance(functions);
        newMetadata.remove(schema, name, argumentDataTypes);
        return newMetadata;
    }

    public void updateImplementations(String schema, Stream<UserDefinedFunctionMetadata> userDefinedFunctions) {
        this.updateImplementations(schema, userDefinedFunctions, this.nodeCtx);
    }

    public void updateImplementations(String schema, Stream<UserDefinedFunctionMetadata> userDefinedFunctions, NodeContext nodeCtx) {
        HashMap<FunctionName, List<FunctionProvider>> implementations = new HashMap<FunctionName, List<FunctionProvider>>();
        Iterator it = userDefinedFunctions.iterator();
        while (it.hasNext()) {
            UserDefinedFunctionMetadata udf = (UserDefinedFunctionMetadata)it.next();
            FunctionProvider resolver = this.buildFunctionResolver(udf);
            if (resolver == null) continue;
            FunctionName functionName = new FunctionName(udf.schema(), udf.name());
            List resolvers = implementations.computeIfAbsent(functionName, k -> new ArrayList());
            resolvers.add(resolver);
        }
        nodeCtx.functions().registerUdfFunctionImplementationsForSchema(schema, implementations);
    }

    @Nullable
    public FunctionProvider buildFunctionResolver(UserDefinedFunctionMetadata udf) {
        Scalar scalar;
        FunctionName functionName = new FunctionName(udf.schema(), udf.name());
        Signature signature = Signature.builder().name(functionName).kind(FunctionType.SCALAR).argumentTypes(Lists2.map(udf.argumentTypes(), DataType::getTypeSignature)).returnType(udf.returnType().getTypeSignature()).build();
        try {
            scalar = this.getLanguage(udf.language()).createFunctionImplementation(udf, signature);
        }
        catch (IllegalArgumentException | ScriptException e) {
            LOGGER.warn("Can't create user defined function: " + udf.specificName(), (Throwable)e);
            return null;
        }
        return new FunctionProvider(signature, (s, args) -> scalar);
    }

    void validateFunctionIsNotInUseByGeneratedColumn(String schema, String functionName, UserDefinedFunctionsMetadata functionsMetadata, ClusterState currentState) {
        NodeContext nodeCtxWithRemovedFunction = new NodeContext(this.nodeCtx.functions().copyOf());
        this.updateImplementations(schema, functionsMetadata.functionsMetadata().stream(), nodeCtxWithRemovedFunction);
        Metadata metadata = currentState.metadata();
        List indices = Stream.of(metadata.getConcreteAllIndices()).filter(DocSchemaInfo.NO_BLOB_NOR_DANGLING).map(IndexParts::new).filter(indexParts -> !indexParts.isPartitioned()).collect(Collectors.toList());
        Iterator<String> templates = metadata.getTemplates().keysIt();
        while (templates.hasNext()) {
            IndexParts indexParts2 = new IndexParts(templates.next());
            if (!indexParts2.isPartitioned()) continue;
            indices.add(indexParts2);
        }
        IndexNameExpressionResolver indexNameExpressionResolver = new IndexNameExpressionResolver();
        for (IndexParts indexParts3 : indices) {
            DocTableInfo tableInfo = new DocTableInfoBuilder(this.nodeCtx, indexParts3.toRelationName(), currentState, indexNameExpressionResolver).build();
            TableReferenceResolver tableReferenceResolver = new TableReferenceResolver(tableInfo.columns(), tableInfo.ident());
            ExpressionAnalyzer exprAnalyzer = new ExpressionAnalyzer(CoordinatorTxnCtx.systemTransactionContext(), nodeCtxWithRemovedFunction, ParamTypeHints.EMPTY, tableReferenceResolver, null);
            for (Reference ref : tableInfo.columns()) {
                if (!(ref instanceof GeneratedReference)) continue;
                GeneratedReference genRef = (GeneratedReference)ref;
                Expression expression = SqlParser.createExpression(genRef.formattedGeneratedExpression());
                try {
                    exprAnalyzer.convert(expression, new ExpressionAnalysisContext());
                }
                catch (UnsupportedOperationException e) {
                    throw new IllegalArgumentException("Cannot drop function '" + functionName + "', it is still in use by '" + tableInfo + "." + genRef + "'");
                }
            }
        }
    }
}

