/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.udf;

import io.crate.analyze.FunctionArgumentDefinition;
import io.crate.exceptions.UnhandledServerException;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class UserDefinedFunctionMetadata
implements Writeable,
ToXContent {
    private final String name;
    private final String schema;
    private final List<FunctionArgumentDefinition> arguments;
    private final DataType<?> returnType;
    private final List<DataType<?>> argumentTypes;
    private final String language;
    private final String definition;
    private final String specificName;

    public UserDefinedFunctionMetadata(String schema, String name, List<FunctionArgumentDefinition> arguments, DataType<?> returnType, String language, String definition) {
        this.schema = schema;
        this.name = name;
        this.arguments = arguments;
        this.returnType = returnType;
        this.language = language;
        this.definition = definition;
        this.argumentTypes = UserDefinedFunctionMetadata.argumentTypesFrom(arguments);
        this.specificName = UserDefinedFunctionMetadata.specificName(name, this.argumentTypes);
    }

    public UserDefinedFunctionMetadata(StreamInput in) throws IOException {
        this.schema = in.readString();
        this.name = in.readString();
        int numArguments = in.readVInt();
        this.arguments = new ArrayList<FunctionArgumentDefinition>(numArguments);
        for (int i = 0; i < numArguments; ++i) {
            this.arguments.add(new FunctionArgumentDefinition(in));
        }
        this.argumentTypes = UserDefinedFunctionMetadata.argumentTypesFrom(this.arguments());
        this.returnType = DataTypes.fromStream(in);
        this.language = in.readString();
        this.definition = in.readString();
        this.specificName = UserDefinedFunctionMetadata.specificName(this.name, this.argumentTypes);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.schema);
        out.writeString(this.name);
        out.writeVInt(this.arguments.size());
        for (FunctionArgumentDefinition argument : this.arguments) {
            argument.writeTo(out);
        }
        DataTypes.toStream(this.returnType, out);
        out.writeString(this.language);
        out.writeString(this.definition);
    }

    public String schema() {
        return this.schema;
    }

    public String name() {
        return this.name;
    }

    public DataType<?> returnType() {
        return this.returnType;
    }

    public String language() {
        return this.language;
    }

    public String definition() {
        return this.definition;
    }

    public List<FunctionArgumentDefinition> arguments() {
        return this.arguments;
    }

    public List<DataType<?>> argumentTypes() {
        return this.argumentTypes;
    }

    public String specificName() {
        return this.specificName;
    }

    boolean sameSignature(String schema, String name, List<DataType<?>> types) {
        return this.schema().equals(schema) && this.name().equals(name) && this.argumentTypes().equals(types);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("schema", this.schema);
        builder.field("name", this.name);
        builder.startArray("arguments");
        for (FunctionArgumentDefinition argument : this.arguments) {
            argument.toXContent(builder, params);
        }
        builder.endArray();
        builder.field("return_type");
        DataTypeXContent.toXContent(this.returnType, builder, params);
        builder.field("language", this.language);
        builder.field("definition", this.definition);
        builder.endObject();
        return builder;
    }

    static UserDefinedFunctionMetadata fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
            throw new IllegalArgumentException("Expected a START_OBJECT but got " + parser.currentToken());
        }
        String schema = null;
        String name = null;
        ArrayList<FunctionArgumentDefinition> arguments = new ArrayList<FunctionArgumentDefinition>();
        DataType<?> returnType = null;
        String language = null;
        String definition = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                if ("schema".equals(parser.currentName())) {
                    schema = UserDefinedFunctionMetadata.parseStringField(parser);
                    continue;
                }
                if ("name".equals(parser.currentName())) {
                    name = UserDefinedFunctionMetadata.parseStringField(parser);
                    continue;
                }
                if ("language".equals(parser.currentName())) {
                    language = UserDefinedFunctionMetadata.parseStringField(parser);
                    continue;
                }
                if ("definition".equals(parser.currentName())) {
                    definition = UserDefinedFunctionMetadata.parseStringField(parser);
                    continue;
                }
                if ("arguments".equals(parser.currentName())) {
                    if (parser.nextToken() != XContentParser.Token.START_ARRAY) {
                        throw new IllegalArgumentException("Expected a START_ARRAY but got " + parser.currentToken());
                    }
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        arguments.add(FunctionArgumentDefinition.fromXContent(parser));
                    }
                    continue;
                }
                if ("return_type".equals(parser.currentName())) {
                    if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
                        throw new IllegalArgumentException("Expected a START_OBJECT but got " + parser.currentToken());
                    }
                    returnType = DataTypeXContent.fromXContent(parser);
                    continue;
                }
                throw new IllegalArgumentException("Got unexpected FIELD_NAME " + parser.currentToken());
            }
            throw new IllegalArgumentException("Expected a FIELD_NAME but got " + parser.currentToken());
        }
        return new UserDefinedFunctionMetadata(schema, name, arguments, returnType, language, definition);
    }

    private static String parseStringField(XContentParser parser) throws IOException {
        if (parser.nextToken() != XContentParser.Token.VALUE_STRING && parser.currentToken() != XContentParser.Token.VALUE_NULL) {
            throw new UnhandledServerException("failed to parse function");
        }
        return parser.textOrNull();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserDefinedFunctionMetadata that = (UserDefinedFunctionMetadata)o;
        return Objects.equals(this.schema, that.schema) && Objects.equals(this.name, that.name) && Objects.equals(this.arguments, that.arguments) && Objects.equals(this.returnType, that.returnType) && Objects.equals(this.language, that.language) && Objects.equals(this.definition, that.definition);
    }

    public int hashCode() {
        return Objects.hash(this.schema, this.name, this.arguments, this.returnType, this.definition, this.language);
    }

    static List<DataType<?>> argumentTypesFrom(List<FunctionArgumentDefinition> arguments) {
        return arguments.stream().map(FunctionArgumentDefinition::type).collect(Collectors.toList());
    }

    static String specificName(String name, List<DataType<?>> types) {
        return String.format(Locale.ENGLISH, "%s(%s)", name, types.stream().map(DataType::getName).collect(Collectors.joining(", ")));
    }

    public static class DataTypeXContent {
        public static XContentBuilder toXContent(DataType<?> type, XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject().field("id", type.id());
            if (type instanceof ArrayType) {
                builder.field("inner_type");
                DataTypeXContent.toXContent(((ArrayType)type).innerType(), builder, params);
            }
            builder.endObject();
            return builder;
        }

        public static DataType<?> fromXContent(XContentParser parser) throws IOException {
            XContentParser.Token token = parser.currentToken();
            if (token != XContentParser.Token.START_OBJECT) {
                throw new IllegalArgumentException("Expected a START_OBJECT but got " + parser.currentToken());
            }
            int id = DataTypes.NOT_SUPPORTED.id();
            DataType innerType = DataTypes.UNDEFINED;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token != XContentParser.Token.FIELD_NAME) continue;
                String fieldName = parser.currentName();
                if ("id".equals(fieldName)) {
                    if (parser.nextToken() != XContentParser.Token.VALUE_NUMBER) {
                        throw new IllegalArgumentException("Expected a VALUE_NUMBER but got " + parser.currentToken());
                    }
                    id = parser.intValue();
                    continue;
                }
                if (!"inner_type".equals(fieldName)) continue;
                if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
                    throw new IllegalArgumentException("Expected a START_OBJECT but got " + parser.currentToken());
                }
                innerType = DataTypeXContent.fromXContent(parser);
            }
            if (id == 100) {
                return new ArrayType<Object>(innerType);
            }
            return DataTypes.fromId(id);
        }
    }
}

