/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.udf;

import io.crate.exceptions.ScriptException;
import io.crate.expression.udf.CreateUserDefinedFunctionRequest;
import io.crate.expression.udf.UserDefinedFunctionMetadata;
import io.crate.expression.udf.UserDefinedFunctionService;
import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

@Singleton
public class TransportCreateUserDefinedFunctionAction
extends TransportMasterNodeAction<CreateUserDefinedFunctionRequest, AcknowledgedResponse> {
    private final UserDefinedFunctionService udfService;

    @Inject
    public TransportCreateUserDefinedFunctionAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, UserDefinedFunctionService udfService, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("internal:crate:sql/udf/create", transportService, clusterService, threadPool, CreateUserDefinedFunctionRequest::new, indexNameExpressionResolver);
        this.udfService = udfService;
    }

    @Override
    protected String executor() {
        return "generic";
    }

    @Override
    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    @Override
    protected void masterOperation(Task task, CreateUserDefinedFunctionRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
        UserDefinedFunctionMetadata metadata = request.userDefinedFunctionMetadata();
        String errorMessage = this.udfService.getLanguage(metadata.language()).validate(metadata);
        if (errorMessage != null) {
            throw new ScriptException(errorMessage, metadata.language());
        }
        this.udfService.registerFunction(metadata, request.replace(), listener, request.masterNodeTimeout());
    }

    @Override
    protected ClusterBlockException checkBlock(CreateUserDefinedFunctionRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

