/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.tablefunctions;

import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.expression.tablefunctions.ColumnOrientedRowsIterator;
import io.crate.expression.tablefunctions.TableFunctionModule;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.metadata.tablefunctions.TableFunctionImplementation;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.RowType;
import io.crate.types.TypeSignature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ValuesFunction {
    public static final String NAME = "_values";
    public static final Signature SIGNATURE = Signature.table("_values", TypeSignature.parseTypeSignature("array(E)"), RowType.EMPTY.getTypeSignature()).withTypeVariableConstraints(TypeVariableConstraint.typeVariableOfAnyType("E")).withVariableArity();

    public static void register(TableFunctionModule module) {
        module.register(SIGNATURE, ValuesTableFunctionImplementation::new);
    }

    private static class ValuesTableFunctionImplementation
    extends TableFunctionImplementation<List<Object>> {
        private final RowType returnType;
        private final Signature signature;
        private final Signature boundSignature;

        private ValuesTableFunctionImplementation(Signature signature, Signature boundSignature) {
            this.signature = signature;
            List<DataType<?>> argTypes = boundSignature.getArgumentDataTypes();
            ArrayList fieldTypes = new ArrayList(argTypes.size());
            for (int i = 0; i < argTypes.size(); ++i) {
                DataType<?> dataType = argTypes.get(i);
                assert (dataType instanceof ArrayType) : "Arguments to _values must be of type array";
                fieldTypes.add(((ArrayType)dataType).innerType());
            }
            this.returnType = new RowType(fieldTypes);
            this.boundSignature = Signature.builder().name(boundSignature.getName()).kind(boundSignature.getKind()).argumentTypes(boundSignature.getArgumentTypes()).returnType(this.returnType.getTypeSignature()).build();
        }

        @Override
        public Signature signature() {
            return this.signature;
        }

        @Override
        public Signature boundSignature() {
            return this.boundSignature;
        }

        @Override
        public final Iterable<Row> evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<List<Object>>[] arguments) {
            return new ColumnOrientedRowsIterator(() -> this.iteratorsFrom(arguments));
        }

        private Iterator<Object>[] iteratorsFrom(Input<List<Object>>[] arguments) {
            Iterator[] iterators = new Iterator[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                List<Object> argument = arguments[i].value();
                iterators[i] = argument == null ? Collections.emptyIterator() : argument.iterator();
            }
            return iterators;
        }

        @Override
        public RowType returnType() {
            return this.returnType;
        }

        @Override
        public boolean hasLazyResultSet() {
            return false;
        }
    }
}

