/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.tablefunctions;

import io.crate.common.collections.Lists2;
import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.expression.tablefunctions.ColumnOrientedRowsIterator;
import io.crate.expression.tablefunctions.TableFunctionModule;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.metadata.tablefunctions.TableFunctionImplementation;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.RowType;
import io.crate.types.TypeSignature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.collect.Iterators;

public class UnnestFunction {
    public static final String NAME = "unnest";

    public static void register(TableFunctionModule module) {
        module.register(Signature.table(NAME, TypeSignature.parseTypeSignature("array(E)"), TypeSignature.parseTypeSignature("E")).withTypeVariableConstraints(TypeVariableConstraint.typeVariable("E")), (signature, boundSignature) -> new UnnestTableFunctionImplementation((Signature)signature, (Signature)boundSignature, new RowType(List.of(boundSignature.getReturnType().createType()))));
        module.register(Signature.table(NAME, TypeSignature.parseTypeSignature("array(E)"), TypeSignature.parseTypeSignature("array(N)"), RowType.EMPTY.getTypeSignature()).withTypeVariableConstraints(TypeVariableConstraint.typeVariable("E"), TypeVariableConstraint.typeVariableOfAnyType("N")).withVariableArity(), (signature, boundSignature) -> {
            List<DataType<?>> argTypes = boundSignature.getArgumentDataTypes();
            ArrayList fieldTypes = new ArrayList(argTypes.size());
            for (int i = 0; i < argTypes.size(); ++i) {
                DataType<?> dataType = argTypes.get(i);
                fieldTypes.add(ArrayType.unnest(dataType));
            }
            RowType returnType = new RowType(fieldTypes);
            return new UnnestTableFunctionImplementation((Signature)signature, Signature.builder().name(boundSignature.getName()).kind(boundSignature.getKind()).argumentTypes(boundSignature.getArgumentTypes()).returnType(returnType.getTypeSignature()).build(), returnType);
        });
        module.register(Signature.table(NAME, DataTypes.UNTYPED_OBJECT.getTypeSignature()), (signature, boundSignature) -> new UnnestTableFunctionImplementation((Signature)signature, (Signature)boundSignature, RowType.EMPTY));
    }

    static class UnnestTableFunctionImplementation
    extends TableFunctionImplementation<List<Object>> {
        private final RowType returnType;
        private final Signature signature;
        private final Signature boundSignature;

        private UnnestTableFunctionImplementation(Signature signature, Signature boundSignature, RowType returnType) {
            this.signature = signature;
            this.boundSignature = boundSignature;
            this.returnType = returnType;
        }

        @Override
        public Signature signature() {
            return this.signature;
        }

        @Override
        public Signature boundSignature() {
            return this.boundSignature;
        }

        @Override
        public RowType returnType() {
            return this.returnType;
        }

        @Override
        public boolean hasLazyResultSet() {
            return false;
        }

        @Override
        @SafeVarargs
        public final Iterable<Row> evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<List<Object>> ... arguments) {
            ArrayList<List<Object>> valuesPerColumn = new ArrayList<List<Object>>(arguments.length);
            for (Input<List<Object>> argument : arguments) {
                valuesPerColumn.add(argument.value());
            }
            return new ColumnOrientedRowsIterator(() -> this.createIterators(valuesPerColumn));
        }

        private Iterator<Object>[] createIterators(ArrayList<List<Object>> valuesPerColumn) {
            Iterator[] iterators = new Iterator[valuesPerColumn.size()];
            for (int i = 0; i < valuesPerColumn.size(); ++i) {
                DataType<?> dataType = this.boundSignature.getArgumentDataTypes().get(i);
                assert (dataType instanceof ArrayType) : "Argument to unnest must be an array";
                iterators[i] = UnnestTableFunctionImplementation.createIterator(valuesPerColumn.get(i), (ArrayType)dataType);
            }
            return iterators;
        }

        private static Iterator<Object> createIterator(List<Object> objects, ArrayType<?> type) {
            if (objects == null) {
                return Collections.emptyIterator();
            }
            if (type.innerType() instanceof ArrayType) {
                List<Iterator> iterators = Lists2.map(objects, x -> UnnestTableFunctionImplementation.createIterator((List)x, (ArrayType)type.innerType()));
                return Iterators.concat(iterators.toArray(new Iterator[0]));
            }
            return objects.iterator();
        }
    }
}

