/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.tablefunctions;

import io.crate.common.collections.Lists2;
import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.metadata.FunctionImplementation;
import io.crate.metadata.FunctionInfo;
import io.crate.metadata.FunctionType;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.tablefunctions.TableFunctionImplementation;
import io.crate.types.RowType;
import io.crate.types.TypeSignature;
import java.util.List;
import java.util.Locale;

public class TableFunctionFactory {
    public static TableFunctionImplementation<?> from(FunctionImplementation functionImplementation) {
        return switch (functionImplementation.signature().getKind()) {
            case FunctionType.TABLE -> (ScalarTableFunctionImplementation)functionImplementation;
            case FunctionType.SCALAR -> new ScalarTableFunctionImplementation((Scalar)functionImplementation);
            case FunctionType.WINDOW, FunctionType.AGGREGATE -> throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Window or Aggregate function: '%s' is not allowed in function in FROM clause", functionImplementation.signature().getName().displayName()));
            default -> throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Unknown type function: '%s' is not allowed in function in FROM clause", functionImplementation.signature().getName().displayName()));
        };
    }

    private static class ScalarTableFunctionImplementation<T>
    extends TableFunctionImplementation<T> {
        private final Scalar<?, T> functionImplementation;
        private final RowType returnType;
        private final Signature signature;
        private final Signature boundSignature;

        private ScalarTableFunctionImplementation(Scalar<?, T> functionImplementation) {
            this.functionImplementation = functionImplementation;
            FunctionInfo info = functionImplementation.info();
            this.returnType = new RowType(List.of(info.returnType()), List.of(info.ident().name()));
            this.signature = Signature.table(functionImplementation.signature().getName(), Lists2.concat(functionImplementation.signature().getArgumentTypes(), functionImplementation.signature().getReturnType()).toArray(new TypeSignature[0]));
            this.boundSignature = Signature.table(functionImplementation.boundSignature().getName(), Lists2.concat(functionImplementation.boundSignature().getArgumentTypes(), functionImplementation.boundSignature().getReturnType()).toArray(new TypeSignature[0]));
        }

        @Override
        public Signature signature() {
            return this.signature;
        }

        @Override
        public Signature boundSignature() {
            return this.boundSignature;
        }

        @Override
        public Iterable<Row> evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<T>[] args) {
            return List.of(new Row1(this.functionImplementation.evaluate(txnCtx, nodeCtx, args)));
        }

        @Override
        public RowType returnType() {
            return this.returnType;
        }

        @Override
        public boolean hasLazyResultSet() {
            return true;
        }
    }
}

