/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.tablefunctions;

import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.data.RowN;
import io.crate.expression.tablefunctions.TableFunctionModule;
import io.crate.metadata.FunctionName;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.metadata.tablefunctions.TableFunctionImplementation;
import io.crate.types.ArrayType;
import io.crate.types.DataTypes;
import io.crate.types.RowType;
import io.crate.types.TypeSignature;
import java.util.List;
import java.util.function.Function;

public final class PgExpandArray
extends TableFunctionImplementation<List<Object>> {
    private static final String NAME = "_pg_expandarray";
    private static final FunctionName FUNCTION_NAME = new FunctionName("information_schema", "_pg_expandarray");
    private final Signature signature;
    private final Signature boundSignature;
    private final RowType resultType;

    public static void register(TableFunctionModule module) {
        module.register(Signature.table(FUNCTION_NAME, TypeSignature.parseTypeSignature("array(E)"), TypeSignature.parseTypeSignature("record(x E, n integer)")).withTypeVariableConstraints(TypeVariableConstraint.typeVariable("E")), PgExpandArray::new);
    }

    public PgExpandArray(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
        ArrayType argType = (ArrayType)boundSignature.getArgumentDataTypes().get(0);
        this.resultType = new RowType(List.of(argType.innerType(), DataTypes.INTEGER), List.of("x", "n"));
    }

    @Override
    @SafeVarargs
    public final Iterable<Row> evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<List<Object>> ... args) {
        List<Object> values = args[0].value();
        if (values == null) {
            return List.of();
        }
        return () -> values.stream().map(new Function<Object, Row>(){
            final Object[] columns = new Object[2];
            final RowN row = new RowN(this.columns);
            int idx = 0;

            @Override
            public Row apply(Object val) {
                ++this.idx;
                this.columns[0] = val;
                this.columns[1] = this.idx;
                return this.row;
            }
        }).iterator();
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public RowType returnType() {
        return this.resultType;
    }

    @Override
    public boolean hasLazyResultSet() {
        return true;
    }
}

