/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.tablefunctions;

import io.crate.common.annotations.VisibleForTesting;
import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.data.RowN;
import io.crate.expression.RegexpFlags;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolType;
import io.crate.expression.tablefunctions.TableFunctionModule;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.tablefunctions.TableFunctionImplementation;
import io.crate.types.DataTypes;
import io.crate.types.RowType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class MatchesFunction
extends TableFunctionImplementation<List<Object>> {
    public static final String NAME = "regexp_matches";
    private static final RowType ROW_TYPE = new RowType(List.of(DataTypes.STRING_ARRAY), List.of("groups"));
    @Nullable
    private final Pattern pattern;
    private final Signature signature;
    private final Signature boundSignature;

    public static void register(TableFunctionModule module) {
        module.register(Signature.table(NAME, DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature(), DataTypes.STRING_ARRAY.getTypeSignature()), MatchesFunction::new);
        module.register(Signature.table(NAME, DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature(), DataTypes.STRING_ARRAY.getTypeSignature()), MatchesFunction::new);
    }

    private MatchesFunction(Signature signature, Signature boundSignature) {
        this(signature, boundSignature, null);
    }

    private MatchesFunction(Signature signature, Signature boundSignature, @Nullable Pattern pattern) {
        this.signature = signature;
        this.boundSignature = boundSignature;
        this.pattern = pattern;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public RowType returnType() {
        return ROW_TYPE;
    }

    @Override
    public boolean hasLazyResultSet() {
        return false;
    }

    @VisibleForTesting
    Pattern pattern() {
        return this.pattern;
    }

    @Override
    public Scalar<Iterable<Row>, List<Object>> compile(List<Symbol> arguments) {
        Literal literal;
        assert (arguments.size() > 1) : "number of arguments must be > 1";
        String pattern = null;
        if (arguments.get(1).symbolType() == SymbolType.LITERAL && (pattern = (String)(literal = (Literal)arguments.get(1)).value()) == null) {
            return this;
        }
        String flags = null;
        if (arguments.size() == 3) {
            assert (arguments.get(2).symbolType() == SymbolType.LITERAL) : "3rd argument must be a " + SymbolType.LITERAL;
            flags = (String)((Literal)arguments.get(2)).value();
        }
        if (pattern != null) {
            return new MatchesFunction(this.signature, this.boundSignature, Pattern.compile(pattern, RegexpFlags.parseFlags(flags)));
        }
        return this;
    }

    @Override
    public Iterable<Row> evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input[] args) {
        List<List<String>> rowGroups;
        assert (args.length == 2 || args.length == 3) : "number of args must be 2 or 3";
        String value = (String)args[0].value();
        String pattern = (String)args[1].value();
        if (value == null || pattern == null) {
            return List.of();
        }
        String flags = null;
        if (args.length == 3) {
            flags = (String)args[2].value();
        }
        Pattern matchPattern = this.pattern == null ? Pattern.compile(pattern, RegexpFlags.parseFlags(flags)) : this.pattern;
        Matcher matcher = matchPattern.matcher(value);
        if (RegexpFlags.isGlobal(flags)) {
            List<String> groups = MatchesFunction.groups(matcher);
            if (groups != null) {
                rowGroups = new ArrayList();
                while (groups != null) {
                    rowGroups.add(groups);
                    groups = MatchesFunction.groups(matcher);
                }
            } else {
                rowGroups = List.of();
            }
        } else {
            List<String> groups = MatchesFunction.groups(matcher);
            rowGroups = groups == null ? List.of() : List.of(groups);
        }
        return () -> new Iterator<Row>(){
            final Object[] columns = new Object[]{null};
            final RowN row = new RowN(this.columns);
            int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < rowGroups.size();
            }

            @Override
            public Row next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("no more rows");
                }
                this.columns[0] = rowGroups.get(this.idx++);
                return this.row;
            }
        };
    }

    private static List<String> groups(Matcher matcher) {
        if (!matcher.find()) {
            return null;
        }
        int groupCount = matcher.groupCount();
        if (groupCount == 0) {
            return List.of(matcher.group());
        }
        ArrayList<String> groups = new ArrayList<String>(groupCount);
        for (int i = 1; i <= groupCount; ++i) {
            groups.add(matcher.group(i));
        }
        return groups;
    }
}

