/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.tablefunctions;

import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.expression.tablefunctions.RangeIterable;
import io.crate.expression.tablefunctions.TableFunctionModule;
import io.crate.metadata.FunctionName;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.metadata.tablefunctions.TableFunctionImplementation;
import io.crate.types.DataTypes;
import io.crate.types.RowType;
import io.crate.types.TypeSignature;
import java.util.List;
import java.util.Locale;

public final class GenerateSubscripts<T>
extends TableFunctionImplementation<T> {
    public static final FunctionName NAME = new FunctionName("pg_catalog", "generate_subscripts");
    private static final RowType RETURN_TYPE = new RowType(List.of(DataTypes.INTEGER), List.of(NAME.name()));
    private final Signature signature;
    private final Signature boundSignature;

    public static void register(TableFunctionModule module) {
        module.register(Signature.table(NAME, TypeSignature.parseTypeSignature("array(E)"), DataTypes.INTEGER.getTypeSignature(), DataTypes.INTEGER.getTypeSignature()).withTypeVariableConstraints(TypeVariableConstraint.typeVariable("E")), GenerateSubscripts::new);
        module.register(Signature.table(NAME, TypeSignature.parseTypeSignature("array(E)"), DataTypes.INTEGER.getTypeSignature(), DataTypes.BOOLEAN.getTypeSignature(), DataTypes.INTEGER.getTypeSignature()).withTypeVariableConstraints(TypeVariableConstraint.typeVariable("E")), GenerateSubscripts::new);
    }

    private GenerateSubscripts(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    private static int getNumRows(List<?> array, int depthLevel) {
        if (depthLevel <= 0) {
            throw new IllegalArgumentException("target level must be greater than zero");
        }
        List<?> targetArray = array;
        for (int level = 2; level <= depthLevel; ++level) {
            if (targetArray == null || targetArray.isEmpty()) {
                return 0;
            }
            int size = -1;
            List firstNonNullElement = null;
            for (int i = 0; i < targetArray.size(); ++i) {
                Object oi = targetArray.get(i);
                if (oi == null) continue;
                if (!(oi instanceof List)) {
                    return 0;
                }
                List element = (List)oi;
                if (size == -1) {
                    size = element.size();
                } else if (size != element.size()) {
                    throw new IllegalArgumentException(String.format(Locale.ENGLISH, "nested arrays must have the same dimension within a level, offending level %d, position %d", level, i + 1));
                }
                if (firstNonNullElement != null) continue;
                firstNonNullElement = element;
            }
            targetArray = firstNonNullElement;
        }
        return targetArray != null ? targetArray.size() : 0;
    }

    @Override
    @SafeVarargs
    public final Iterable<Row> evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<T> ... args) {
        assert (args.length == 2 || args.length == 3) : "Signature must ensure that there are either two or three arguments";
        List array = (List)args[0].value();
        Integer dim = (Integer)args[1].value();
        if (array == null || array.isEmpty() || dim == null) {
            return List.of();
        }
        int numRows = GenerateSubscripts.getNumRows(array, dim);
        if (numRows == 0) {
            return List.of();
        }
        Boolean rev = null;
        if (args.length == 3) {
            rev = (Boolean)args[2].value();
        }
        boolean reversed = rev != null && rev != false;
        int startInclusive = reversed ? numRows : 1;
        int stopInclusive = reversed ? 1 : numRows;
        int step = reversed ? -1 : 1;
        return new RangeIterable<Integer>(startInclusive, stopInclusive, value -> value + step, Integer::compareTo, i -> i);
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public RowType returnType() {
        return RETURN_TYPE;
    }

    @Override
    public boolean hasLazyResultSet() {
        return true;
    }
}

