/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.tablefunctions;

import io.crate.data.Row;
import io.crate.data.RowN;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

class ColumnOrientedRowsIterator
implements Iterable<Row> {
    private final Supplier<Iterator<Object>[]> iteratorsPerColumn;

    ColumnOrientedRowsIterator(Supplier<Iterator<Object>[]> iteratorsPerColumn) {
        this.iteratorsPerColumn = iteratorsPerColumn;
    }

    @Override
    @Nonnull
    public Iterator<Row> iterator() {
        final Iterator[] iterators = this.iteratorsPerColumn.get();
        final Object[] cells = new Object[iterators.length];
        final RowN row = new RowN(cells);
        return new Iterator<Row>(){

            @Override
            public boolean hasNext() {
                for (Iterator it : iterators) {
                    if (!it.hasNext()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Row next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more rows");
                }
                for (int i = 0; i < iterators.length; ++i) {
                    Iterator iterator = iterators[i];
                    cells[i] = iterator.hasNext() ? iterator.next() : null;
                }
                return row;
            }
        };
    }
}

