/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.symbol;

import io.crate.analyze.FrameBoundDefinition;
import io.crate.analyze.OrderBy;
import io.crate.analyze.WindowDefinition;
import io.crate.analyze.WindowFrameDefinition;
import io.crate.common.collections.Lists2;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolType;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.expression.symbol.format.Style;
import io.crate.metadata.FunctionType;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class WindowFunction
extends Function {
    private final WindowDefinition windowDefinition;

    public WindowFunction(StreamInput in) throws IOException {
        super(in);
        this.windowDefinition = new WindowDefinition(in);
    }

    public WindowFunction(Signature signature, List<Symbol> arguments, DataType<?> returnType, @Nullable Symbol filter, WindowDefinition windowDefinition) {
        super(signature, arguments, returnType, filter);
        assert (signature.getKind() == FunctionType.WINDOW || signature.getKind() == FunctionType.AGGREGATE) : "only window and aggregate functions are allowed to be modelled over a window";
        this.windowDefinition = windowDefinition;
    }

    public WindowDefinition windowDefinition() {
        return this.windowDefinition;
    }

    @Override
    public <C, R> R accept(SymbolVisitor<C, R> visitor, C context) {
        return visitor.visitWindowFunction(this, context);
    }

    @Override
    public SymbolType symbolType() {
        return SymbolType.WINDOW_FUNCTION;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.windowDefinition.writeTo(out);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WindowFunction that = (WindowFunction)o;
        return this.windowDefinition.equals(that.windowDefinition);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.windowDefinition);
    }

    @Override
    public String toString(Style style) {
        WindowFrameDefinition frameDefinition;
        OrderBy orderBy;
        StringBuilder builder = new StringBuilder(super.toString(style));
        builder.append(" OVER (");
        List<Symbol> partitions = this.windowDefinition.partitions();
        if (!partitions.isEmpty()) {
            builder.append("PARTITION BY ");
            builder.append(Lists2.joinOn(", ", partitions, x -> x.toString(style)));
        }
        if ((orderBy = this.windowDefinition.orderBy()) != null) {
            if (!partitions.isEmpty()) {
                builder.append(" ");
            }
            builder.append("ORDER BY ");
            OrderBy.explainRepresentation(builder, orderBy.orderBySymbols(), orderBy.reverseFlags(), orderBy.nullsFirst(), x -> x.toString(style));
        }
        if ((frameDefinition = this.windowDefinition.windowFrameDefinition()) != WindowDefinition.RANGE_UNBOUNDED_PRECEDING_CURRENT_ROW) {
            builder.append(" ");
            builder.append(frameDefinition.mode().name());
            builder.append(" BETWEEN ");
            this.appendFrameBound(builder, style, frameDefinition.start());
            builder.append(" AND ");
            this.appendFrameBound(builder, style, frameDefinition.end());
        }
        builder.append(")");
        return builder.toString();
    }

    private void appendFrameBound(StringBuilder builder, Style style, FrameBoundDefinition frameBound) {
        switch (frameBound.type()) {
            case UNBOUNDED_PRECEDING: {
                builder.append("UNBOUNDED PRECEDING");
                break;
            }
            case PRECEDING: {
                builder.append(frameBound.value().toString(style));
                builder.append(" PRECEDING");
                break;
            }
            case CURRENT_ROW: {
                builder.append("CURRENT ROW");
                break;
            }
            case FOLLOWING: {
                builder.append(frameBound.value().toString(style));
                builder.append("FOLLOWING");
                break;
            }
            case UNBOUNDED_FOLLOWING: {
                builder.append("UNBOUNDED FOLLOWING");
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected frame bound type: " + frameBound.type()));
            }
        }
    }
}

