/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.symbol;

import io.crate.Streamer;
import io.crate.common.collections.Lists2;
import io.crate.expression.scalar.cast.CastFunctionResolver;
import io.crate.expression.symbol.AliasSymbol;
import io.crate.expression.symbol.FetchReference;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolType;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.expression.symbol.format.Style;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.FunctionType;
import io.crate.metadata.GeneratedReference;
import io.crate.metadata.Reference;
import io.crate.types.DataType;
import io.crate.types.TypeSignature;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class Symbols {
    private static final HasColumnVisitor HAS_COLUMN_VISITOR = new HasColumnVisitor();
    public static final Predicate<Symbol> IS_COLUMN = s -> s instanceof ScopedSymbol || s instanceof Reference;
    public static final Predicate<Symbol> IS_GENERATED_COLUMN = input -> input instanceof GeneratedReference;

    public static boolean isAggregate(Symbol s) {
        return s instanceof Function && ((Function)s).type() == FunctionType.AGGREGATE;
    }

    public static List<DataType<?>> typeView(List<? extends Symbol> symbols) {
        return Lists2.mapLazy(symbols, Symbol::valueType);
    }

    public static List<TypeSignature> typeSignatureView(List<? extends Symbol> symbols) {
        return Lists2.mapLazy(symbols, s -> s.valueType().getTypeSignature());
    }

    public static Streamer<?>[] streamerArray(Collection<? extends Symbol> symbols) {
        Streamer[] streamers = new Streamer[symbols.size()];
        Iterator<? extends Symbol> iter = symbols.iterator();
        for (int i = 0; i < symbols.size(); ++i) {
            streamers[i] = iter.next().valueType().streamer();
        }
        return streamers;
    }

    @Nullable
    public static <V> V lookupValueByColumn(Map<? extends Symbol, V> valuesBySymbol, ColumnIdent column) {
        for (Map.Entry<Symbol, V> entry : valuesBySymbol.entrySet()) {
            Symbol key = entry.getKey();
            if (key instanceof Reference && ((Reference)key).column().equals(column)) {
                return entry.getValue();
            }
            if (!(key instanceof ScopedSymbol) || !((ScopedSymbol)key).column().equals(column)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static boolean containsColumn(@Nullable Symbol symbol, ColumnIdent path) {
        if (symbol == null) {
            return false;
        }
        return symbol.accept(HAS_COLUMN_VISITOR, path);
    }

    public static boolean containsColumn(Iterable<? extends Symbol> symbols, ColumnIdent path) {
        for (Symbol symbol : symbols) {
            if (!Symbols.containsColumn(symbol, path)) continue;
            return true;
        }
        return false;
    }

    public static void toStream(Collection<? extends Symbol> symbols, StreamOutput out) throws IOException {
        out.writeVInt(symbols.size());
        for (Symbol symbol : symbols) {
            Symbols.toStream(symbol, out);
        }
    }

    public static void nullableToStream(@Nullable Symbol symbol, StreamOutput out) throws IOException {
        if (symbol == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeVInt(symbol.symbolType().ordinal());
            symbol.writeTo(out);
        }
    }

    public static void toStream(Symbol symbol, StreamOutput out) throws IOException {
        if (out.getVersion().before(Version.V_4_2_0) && symbol instanceof AliasSymbol) {
            Symbols.toStream(((AliasSymbol)symbol).symbol(), out);
        } else {
            int ordinal = symbol.symbolType().ordinal();
            out.writeVInt(ordinal);
            symbol.writeTo(out);
        }
    }

    public static List<Symbol> listFromStream(StreamInput in) throws IOException {
        return in.readList(Symbols::fromStream);
    }

    @Nullable
    public static Symbol nullableFromStream(StreamInput in) throws IOException {
        boolean valuePresent = in.readBoolean();
        if (!valuePresent) {
            return null;
        }
        return Symbols.fromStream(in);
    }

    public static Symbol fromStream(StreamInput in) throws IOException {
        return SymbolType.VALUES.get(in.readVInt()).newInstance(in);
    }

    public static ColumnIdent pathFromSymbol(Symbol symbol) {
        if (symbol instanceof AliasSymbol) {
            return new ColumnIdent(((AliasSymbol)symbol).alias());
        }
        if (symbol instanceof ScopedSymbol) {
            return ((ScopedSymbol)symbol).column();
        }
        if (symbol instanceof Reference) {
            return ((Reference)symbol).column();
        }
        return new ColumnIdent(symbol.toString(Style.UNQUALIFIED));
    }

    public static String format(String messageTmpl, Symbol ... symbols) {
        Object[] formattedSymbols = new String[symbols.length];
        for (int i = 0; i < symbols.length; ++i) {
            Symbol s = symbols[i];
            formattedSymbols[i] = s == null ? "NULL" : s.toString(Style.UNQUALIFIED);
        }
        return String.format(Locale.ENGLISH, messageTmpl, formattedSymbols);
    }

    public static Symbol unwrapReferenceFromCast(Symbol symbol) {
        if (symbol instanceof Function && CastFunctionResolver.CAST_FUNCTION_NAMES.contains(((Function)symbol).name())) {
            return ((Function)symbol).arguments().get(0);
        }
        return symbol;
    }

    private static class HasColumnVisitor
    extends SymbolVisitor<ColumnIdent, Boolean> {
        private HasColumnVisitor() {
        }

        @Override
        protected Boolean visitSymbol(Symbol symbol, ColumnIdent column) {
            return false;
        }

        @Override
        public Boolean visitFunction(Function symbol, ColumnIdent column) {
            for (Symbol arg : symbol.arguments()) {
                if (!arg.accept(this, column).booleanValue()) continue;
                return true;
            }
            return false;
        }

        @Override
        public Boolean visitFetchReference(FetchReference fetchReference, ColumnIdent column) {
            if (((Symbol)fetchReference.fetchId()).accept(this, column).booleanValue()) {
                return true;
            }
            return ((Symbol)fetchReference.ref()).accept(this, column);
        }

        @Override
        public Boolean visitField(ScopedSymbol field, ColumnIdent column) {
            return field.column().equals(column);
        }

        @Override
        public Boolean visitReference(Reference symbol, ColumnIdent column) {
            return column.equals(symbol.column());
        }
    }
}

