/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.symbol;

import io.crate.analyze.OrderBy;
import io.crate.analyze.WindowDefinition;
import io.crate.expression.symbol.AliasSymbol;
import io.crate.expression.symbol.FetchReference;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.MatchPredicate;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.expression.symbol.WindowFunction;
import io.crate.metadata.ColumnIdent;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class SymbolVisitors {
    private static final AnyPredicateVisitor ANY_VISITOR = new AnyPredicateVisitor();

    public static boolean any(Predicate<? super Symbol> predicate, List<? extends Symbol> symbols) {
        for (int i = 0; i < symbols.size(); ++i) {
            if (!SymbolVisitors.any(predicate, symbols.get(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean any(Predicate<? super Symbol> symbolPredicate, Symbol symbol) {
        return symbol.accept(ANY_VISITOR, symbolPredicate);
    }

    public static <T> void intersection(Symbol needle, Collection<T> haystack, Consumer<T> consumer) {
        needle.accept(new IntersectionVisitor<T>(haystack, consumer), null);
    }

    private static class AnyPredicateVisitor
    extends SymbolVisitor<Predicate<? super Symbol>, Boolean> {
        private AnyPredicateVisitor() {
        }

        @Override
        public Boolean visitFunction(Function symbol, Predicate<? super Symbol> symbolPredicate) {
            if (symbolPredicate.test(symbol)) {
                return true;
            }
            for (Symbol arg : symbol.arguments()) {
                if (!arg.accept(this, symbolPredicate).booleanValue()) continue;
                return true;
            }
            return false;
        }

        @Override
        public Boolean visitWindowFunction(WindowFunction symbol, Predicate<? super Symbol> context) {
            return this.visitFunction((Function)symbol, context);
        }

        @Override
        public Boolean visitFetchReference(FetchReference fetchReference, Predicate<? super Symbol> symbolPredicate) {
            return symbolPredicate.test(fetchReference) || fetchReference.fetchId().accept(this, symbolPredicate) != false || fetchReference.ref().accept(this, symbolPredicate) != false;
        }

        @Override
        public Boolean visitMatchPredicate(MatchPredicate matchPredicate, Predicate<? super Symbol> symbolPredicate) {
            if (symbolPredicate.test(matchPredicate)) {
                return true;
            }
            for (Symbol field : matchPredicate.identBoostMap().keySet()) {
                if (!field.accept(this, symbolPredicate).booleanValue()) continue;
                return true;
            }
            return false;
        }

        @Override
        public Boolean visitAlias(AliasSymbol aliasSymbol, Predicate<? super Symbol> predicate) {
            if (predicate.test(aliasSymbol)) {
                return true;
            }
            return aliasSymbol.symbol().accept(this, predicate);
        }

        @Override
        protected Boolean visitSymbol(Symbol symbol, Predicate<? super Symbol> symbolPredicate) {
            return symbolPredicate.test(symbol);
        }
    }

    private static class IntersectionVisitor<T>
    extends SymbolVisitor<Void, Void> {
        private final Collection<T> haystack;
        private final Consumer<T> consumer;

        public IntersectionVisitor(Collection<T> haystack, Consumer<T> consumer) {
            this.haystack = haystack;
            this.consumer = consumer;
        }

        @Override
        public Void visitFunction(Function func, Void context) {
            if (this.haystack.contains(func)) {
                this.consumer.accept(func);
            } else {
                for (Symbol argument : func.arguments()) {
                    this.callConsumerOrVisit(argument);
                }
                Symbol filter = func.filter();
                if (filter != null) {
                    this.callConsumerOrVisit(filter);
                }
            }
            return null;
        }

        @Override
        public Void visitWindowFunction(WindowFunction windowFunc, Void context) {
            if (this.haystack.contains(windowFunc)) {
                this.consumer.accept(windowFunc);
            } else {
                Symbol endOffsetValue;
                Symbol symbol;
                for (Symbol argument : windowFunc.arguments()) {
                    this.callConsumerOrVisit(argument);
                }
                Symbol filter = windowFunc.filter();
                if (filter != null) {
                    this.callConsumerOrVisit(filter);
                }
                WindowDefinition windowDefinition = windowFunc.windowDefinition();
                for (Symbol symbol2 : windowDefinition.partitions()) {
                    this.callConsumerOrVisit(symbol2);
                }
                OrderBy orderBy = windowDefinition.orderBy();
                if (orderBy != null) {
                    for (Symbol orderBySymbol : orderBy.orderBySymbols()) {
                        this.callConsumerOrVisit(orderBySymbol);
                    }
                }
                if ((symbol = windowDefinition.windowFrameDefinition().start().value()) != null) {
                    this.callConsumerOrVisit(symbol);
                }
                if ((endOffsetValue = windowDefinition.windowFrameDefinition().end().value()) != null) {
                    this.callConsumerOrVisit(endOffsetValue);
                }
            }
            return null;
        }

        private void callConsumerOrVisit(Symbol symbol) {
            if (this.haystack.contains(symbol)) {
                this.consumer.accept(symbol);
            } else {
                symbol.accept(this, null);
            }
        }

        @Override
        public Void visitAlias(AliasSymbol aliasSymbol, Void context) {
            if (this.haystack.contains(aliasSymbol)) {
                this.consumer.accept(aliasSymbol);
            } else {
                aliasSymbol.symbol().accept(this, context);
            }
            return null;
        }

        @Override
        public Void visitField(ScopedSymbol field, Void context) {
            if (this.haystack.contains(field)) {
                this.consumer.accept(field);
            } else if (!field.column().isTopLevel()) {
                ColumnIdent root = field.column().getRoot();
                for (T t : this.haystack) {
                    if (!(t instanceof ScopedSymbol) || !((ScopedSymbol)t).column().equals(root)) continue;
                    this.consumer.accept(t);
                }
            }
            return null;
        }

        @Override
        protected Void visitSymbol(Symbol symbol, Void context) {
            if (this.haystack.contains(symbol)) {
                this.consumer.accept(symbol);
            }
            return null;
        }
    }
}

