/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.symbol;

import io.crate.expression.scalar.cast.CastFunctionResolver;
import io.crate.expression.scalar.cast.CastMode;
import io.crate.expression.symbol.SymbolType;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.expression.symbol.format.Style;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import org.elasticsearch.common.io.stream.Writeable;

public abstract class Symbol
implements Writeable {
    public static boolean isLiteral(Symbol symbol, DataType<?> expectedType) {
        return symbol.symbolType() == SymbolType.LITERAL && symbol.valueType().equals(expectedType);
    }

    public abstract SymbolType symbolType();

    public abstract <C, R> R accept(SymbolVisitor<C, R> var1, C var2);

    public abstract DataType<?> valueType();

    public Symbol cast(DataType<?> targetType, CastMode ... modes) {
        if (targetType.equals(this.valueType())) {
            return this;
        }
        if (ArrayType.unnest(targetType).equals(DataTypes.UNTYPED_OBJECT) && this.valueType().id() == targetType.id()) {
            return this;
        }
        if (ArrayType.unnest(targetType).equals(DataTypes.NUMERIC) && this.valueType().id() == DataTypes.NUMERIC.id()) {
            return this;
        }
        return CastFunctionResolver.generateCastFunction(this, targetType, modes);
    }

    public final String toString() {
        return this.toString(Style.UNQUALIFIED);
    }

    public abstract String toString(Style var1);
}

