/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.symbol;

import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolType;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.expression.symbol.format.Style;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamOutput;

public class SelectSymbol
extends Symbol {
    private final AnalyzedRelation relation;
    private final ArrayType<?> dataType;
    private final ResultType resultType;

    public SelectSymbol(AnalyzedRelation relation, ArrayType<?> dataType, ResultType resultType) {
        this.relation = relation;
        this.dataType = dataType;
        this.resultType = resultType;
    }

    public AnalyzedRelation relation() {
        return this.relation;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("Cannot stream SelectSymbol");
    }

    @Override
    public SymbolType symbolType() {
        return SymbolType.SELECT_SYMBOL;
    }

    @Override
    public <C, R> R accept(SymbolVisitor<C, R> visitor, C context) {
        return visitor.visitSelectSymbol(this, context);
    }

    @Override
    public DataType<?> valueType() {
        if (this.resultType == ResultType.SINGLE_COLUMN_SINGLE_VALUE) {
            return this.dataType.innerType();
        }
        return this.dataType;
    }

    @Override
    public String toString(Style style) {
        return "(" + this.relation + ")";
    }

    public ResultType getResultType() {
        return this.resultType;
    }

    public static enum ResultType {
        SINGLE_COLUMN_SINGLE_VALUE,
        SINGLE_COLUMN_MULTIPLE_VALUES;

    }
}

