/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.symbol;

import io.crate.expression.scalar.cast.CastMode;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolType;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.expression.symbol.format.Style;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class ParameterSymbol
extends Symbol {
    private final int index;
    private final DataType<?> boundType;
    private final DataType<?> internalType;

    public ParameterSymbol(int index, DataType<?> type) {
        this(index, type, type);
    }

    private ParameterSymbol(int index, DataType<?> boundType, DataType<?> internalType) {
        this.index = index;
        this.boundType = boundType;
        this.internalType = internalType;
    }

    public ParameterSymbol(StreamInput in) throws IOException {
        this.index = in.readVInt();
        this.boundType = DataTypes.fromStream(in);
        this.internalType = DataTypes.fromStream(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.index);
        DataTypes.toStream(this.boundType, out);
        DataTypes.toStream(this.internalType, out);
    }

    @Override
    public SymbolType symbolType() {
        return SymbolType.PARAMETER;
    }

    @Override
    public ParameterSymbol cast(DataType<?> targetType, CastMode ... modes) {
        return new ParameterSymbol(this.index, this.boundType, targetType);
    }

    @Override
    public <C, R> R accept(SymbolVisitor<C, R> visitor, C context) {
        return visitor.visitParameterSymbol(this, context);
    }

    public DataType<?> getBoundType() {
        if (this.boundType.id() == 0) {
            return this.internalType;
        }
        return this.boundType;
    }

    @Override
    public DataType<?> valueType() {
        return this.internalType;
    }

    @Override
    public String toString(Style style) {
        return "$" + (this.index + 1);
    }

    public int index() {
        return this.index;
    }
}

