/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.symbol;

import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolType;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.expression.symbol.format.Style;
import io.crate.types.BooleanType;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamOutput;

public class MatchPredicate
extends Symbol {
    private final Map<Symbol, Symbol> identBoostMap;
    private final Symbol queryTerm;
    private final String matchType;
    private final Symbol options;

    public MatchPredicate(Map<Symbol, Symbol> identBoostMap, Symbol queryTerm, String matchType, Symbol options) {
        assert (options.valueType().id() == 12) : "options symbol must be of type object";
        this.identBoostMap = identBoostMap;
        this.queryTerm = queryTerm;
        this.matchType = matchType;
        this.options = options;
    }

    public Map<Symbol, Symbol> identBoostMap() {
        return this.identBoostMap;
    }

    public Symbol queryTerm() {
        return this.queryTerm;
    }

    public String matchType() {
        return this.matchType;
    }

    public Symbol options() {
        return this.options;
    }

    @Override
    public SymbolType symbolType() {
        return SymbolType.MATCH_PREDICATE;
    }

    @Override
    public <C, R> R accept(SymbolVisitor<C, R> visitor, C context) {
        return visitor.visitMatchPredicate(this, context);
    }

    public BooleanType valueType() {
        return DataTypes.BOOLEAN;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("Cannot stream MatchPredicate");
    }

    @Override
    public String toString(Style style) {
        StringBuilder sb = new StringBuilder("MATCH((");
        Iterator<Map.Entry<Symbol, Symbol>> it = this.identBoostMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Symbol, Symbol> entry = it.next();
            sb.append(entry.getKey().toString(style));
            sb.append(" ");
            sb.append(entry.getValue().toString(style));
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("), ");
        sb.append(this.queryTerm.toString(style));
        sb.append(") USING ");
        sb.append(this.matchType);
        sb.append(" WITH (");
        sb.append(this.options.toString(style));
        sb.append(")");
        return sb.toString();
    }
}

