/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.symbol;

import io.crate.sql.Literals;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.joda.time.Period;
import org.locationtech.spatial4j.shape.Point;

public class LiteralValueFormatter {
    private static final LiteralValueFormatter INSTANCE = new LiteralValueFormatter();

    public static void format(Object value, StringBuilder builder) {
        INSTANCE.formatValue(value, builder);
    }

    private LiteralValueFormatter() {
    }

    public void formatValue(Object value, StringBuilder builder) {
        if (value == null) {
            builder.append("NULL");
        } else if (value instanceof Map) {
            this.formatMap((Map)value, builder);
        } else if (value instanceof Collection) {
            this.formatIterable((Iterable)value, builder);
        } else if (value.getClass().isArray()) {
            this.formatArray(value, builder);
        } else if (value instanceof String || value instanceof Point || value instanceof Period) {
            builder.append(Literals.quoteStringLiteral(value.toString()));
        } else if (value instanceof Long && ((Long)value <= Integer.MAX_VALUE || (Long)value >= Integer.MIN_VALUE)) {
            builder.append(value.toString());
            builder.append("::bigint");
        } else {
            builder.append(value.toString());
        }
    }

    private void formatIterable(Iterable<?> iterable, StringBuilder builder) {
        builder.append('[');
        Iterator<?> it = iterable.iterator();
        while (it.hasNext()) {
            Object elem = it.next();
            this.formatValue(elem, builder);
            if (!it.hasNext()) continue;
            builder.append(", ");
        }
        builder.append(']');
    }

    private void formatMap(Map<String, Object> map, StringBuilder builder) {
        builder.append("{");
        Iterator it = map.entrySet().stream().sorted(Map.Entry.comparingByKey()).iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            this.formatIdentifier((String)entry.getKey(), builder);
            builder.append("=");
            this.formatValue(entry.getValue(), builder);
            if (!it.hasNext()) continue;
            builder.append(", ");
        }
        builder.append("}");
    }

    private void formatIdentifier(String identifier, StringBuilder builder) {
        builder.append('\"').append(identifier).append('\"');
    }

    private void formatArray(Object array, StringBuilder builder) {
        builder.append('[');
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            this.formatValue(Array.get(array, i), builder);
            if (i + 1 >= length) continue;
            builder.append(", ");
        }
        builder.append(']');
    }
}

