/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.symbol;

import io.crate.expression.symbol.AliasSymbol;
import io.crate.expression.symbol.DynamicReference;
import io.crate.expression.symbol.FetchMarker;
import io.crate.expression.symbol.FetchStub;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.MatchPredicate;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.expression.symbol.WindowFunction;
import io.crate.metadata.Reference;
import io.crate.metadata.functions.Signature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public abstract class FunctionCopyVisitor<C>
extends SymbolVisitor<C, Symbol> {
    protected Function processAndMaybeCopy(Function func, C context) {
        List<Symbol> args = func.arguments();
        switch (args.size()) {
            case 0: {
                return this.zeroArg(func, context);
            }
            case 1: {
                return this.oneArg(func, context);
            }
            case 2: {
                return this.twoArgs(func, context);
            }
        }
        return this.manyArgs(func, context);
    }

    private Function manyArgs(Function func, C context) {
        List<Symbol> args = func.arguments();
        ArrayList<Symbol> newArgs = new ArrayList<Symbol>(args.size());
        Symbol filter = func.filter();
        Symbol newFilter = this.processNullable(filter, context);
        boolean changed = false;
        for (Symbol arg : args) {
            Symbol newArg;
            changed |= arg != (newArg = Objects.requireNonNull((Symbol)arg.accept(this, context), "function arguments must never be NULL"));
            newArgs.add(newArg);
        }
        if (changed |= filter != newFilter) {
            Signature signature = func.signature();
            assert (signature != null) : "Expecting signature not to be null";
            return new Function(signature, newArgs, func.valueType(), newFilter);
        }
        return func;
    }

    private Function twoArgs(Function func, C context) {
        assert (func.arguments().size() == 2) : "size of arguments must be two";
        Symbol arg1 = func.arguments().get(0);
        Symbol newArg1 = (Symbol)arg1.accept(this, context);
        assert (newArg1 != null) : arg1 + " became NULL, symbols must never convert to NULL";
        Symbol arg2 = func.arguments().get(1);
        Symbol newArg2 = (Symbol)arg2.accept(this, context);
        assert (newArg2 != null) : arg2 + " became NULL, symbols must never convert to NULL";
        Symbol filter = func.filter();
        Symbol newFilter = this.processNullable(filter, context);
        if (arg1 == newArg1 && arg2 == newArg2 && filter == newFilter) {
            return func;
        }
        Signature signature = func.signature();
        assert (signature != null) : "Expecting signature not to be null";
        return new Function(signature, List.of(newArg1, newArg2), func.valueType(), newFilter);
    }

    private Function zeroArg(Function func, C context) {
        assert (func.arguments().size() == 0) : "size of arguments must be zero";
        Symbol filter = func.filter();
        if (filter == null) {
            return func;
        }
        Symbol newFilter = (Symbol)filter.accept(this, context);
        if (filter == newFilter) {
            return func;
        }
        Signature signature = func.signature();
        assert (signature != null) : "Expecting signature not to be null";
        return new Function(signature, List.of(), func.valueType(), newFilter);
    }

    private Function oneArg(Function func, C context) {
        assert (func.arguments().size() == 1) : "size of arguments must be one";
        Symbol arg = func.arguments().get(0);
        Symbol newArg = Objects.requireNonNull((Symbol)arg.accept(this, context), "function arguments must never be NULL");
        Symbol filter = func.filter();
        Symbol newFilter = this.processNullable(filter, context);
        if (arg == newArg && filter == newFilter) {
            return func;
        }
        Signature signature = func.signature();
        assert (signature != null) : "Expecting signature not to be null";
        return new Function(signature, List.of(newArg), func.valueType(), newFilter);
    }

    @Nullable
    private Symbol processNullable(@Nullable Symbol symbol, C context) {
        if (symbol != null) {
            return (Symbol)symbol.accept(this, context);
        }
        return null;
    }

    @Override
    public Symbol visitFunction(Function func, C context) {
        return this.processAndMaybeCopy(func, context);
    }

    @Override
    public Symbol visitWindowFunction(WindowFunction windowFunction, C context) {
        Function processedFunction = this.processAndMaybeCopy(windowFunction, context);
        return new WindowFunction(processedFunction.signature(), processedFunction.arguments(), processedFunction.valueType(), this.processNullable(windowFunction.filter(), context), windowFunction.windowDefinition().map(s -> (Symbol)s.accept(this, context)));
    }

    @Override
    public Symbol visitMatchPredicate(MatchPredicate matchPredicate, C context) {
        Symbol queryTerm = (Symbol)matchPredicate.queryTerm().accept(this, context);
        HashMap<Symbol, Symbol> identBootMap = new HashMap<Symbol, Symbol>();
        for (Map.Entry<Symbol, Symbol> entry : matchPredicate.identBoostMap().entrySet()) {
            identBootMap.put((Symbol)entry.getKey().accept(this, context), (Symbol)entry.getValue().accept(this, context));
        }
        return new MatchPredicate(identBootMap, queryTerm, matchPredicate.matchType(), (Symbol)matchPredicate.options().accept(this, context));
    }

    @Override
    public Symbol visitAlias(AliasSymbol aliasSymbol, C context) {
        Symbol newSymbol;
        Symbol symbol = aliasSymbol.symbol();
        if (symbol == (newSymbol = (Symbol)symbol.accept(this, context))) {
            return aliasSymbol;
        }
        return new AliasSymbol(aliasSymbol.alias(), newSymbol);
    }

    @Override
    public Symbol visitFetchMarker(FetchMarker fetchMarker, C context) {
        return this.visitSymbol((Symbol)fetchMarker, (Object)context);
    }

    @Override
    public Symbol visitFetchStub(FetchStub fetchStub, C context) {
        FetchMarker fetchMarker = fetchStub.fetchMarker();
        Symbol newFetchMarker = (Symbol)fetchMarker.accept(this, context);
        Reference ref = fetchStub.ref();
        Symbol newRefSymbol = (Symbol)ref.accept(this, context);
        if (newFetchMarker == fetchMarker && ref == newRefSymbol) {
            return fetchStub;
        }
        Reference newRef = newRefSymbol instanceof Reference ? (Reference)newRefSymbol : ref;
        FetchMarker newMarker = newFetchMarker instanceof FetchMarker ? (FetchMarker)newFetchMarker : fetchMarker;
        return new FetchStub(newMarker, newRef);
    }

    @Override
    public Symbol visitDynamicReference(DynamicReference ref, C context) {
        return (Symbol)this.visitReference(ref, context);
    }

    @Override
    protected Symbol visitSymbol(Symbol symbol, C context) {
        return symbol;
    }
}

