/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.symbol;

import io.crate.exceptions.ConversionException;
import io.crate.expression.scalar.cast.CastMode;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolType;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.expression.symbol.Symbols;
import io.crate.expression.symbol.format.MatchPrinter;
import io.crate.expression.symbol.format.Style;
import io.crate.metadata.FunctionInfo;
import io.crate.metadata.FunctionName;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Reference;
import io.crate.metadata.Scalar;
import io.crate.metadata.functions.Signature;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class Function
extends Symbol
implements Cloneable {
    private static final Map<String, String> ARITHMETIC_OPERATOR_MAPPING = Map.ofEntries(Map.entry("add", "+"), Map.entry("subtract", "-"), Map.entry("multiply", "*"), Map.entry("divide", "/"), Map.entry("mod", "%"), Map.entry("modulus", "%"));
    private final List<Symbol> arguments;
    protected final DataType<?> returnType;
    private final FunctionInfo info;
    @Nullable
    protected final Signature signature;
    @Nullable
    protected final Symbol filter;

    public Function(StreamInput in) throws IOException {
        this.info = new FunctionInfo(in);
        this.filter = in.getVersion().onOrAfter(Version.V_4_1_0) ? Symbols.nullableFromStream(in) : null;
        this.arguments = List.copyOf(Symbols.listFromStream(in));
        if (in.getVersion().onOrAfter(Version.V_4_2_0) && in.readBoolean()) {
            this.signature = new Signature(in);
            this.returnType = DataTypes.fromStream(in);
        } else {
            this.signature = null;
            this.returnType = this.info.returnType();
        }
    }

    public Function(Signature signature, List<Symbol> arguments, DataType<?> returnType) {
        this(signature, arguments, returnType, null);
    }

    public Function(Signature signature, List<Symbol> arguments, DataType<?> returnType, Symbol filter) {
        this.info = FunctionInfo.of(signature, Symbols.typeView(arguments), returnType);
        this.signature = signature;
        this.arguments = List.copyOf(arguments);
        this.returnType = returnType;
        this.filter = filter;
    }

    public List<Symbol> arguments() {
        return this.arguments;
    }

    public FunctionInfo info() {
        return this.info;
    }

    public String name() {
        if (this.signature != null) {
            return this.signature.getName().name();
        }
        return this.info.ident().name();
    }

    public boolean hasFeature(Scalar.Feature feature) {
        if (this.signature != null) {
            return this.signature.hasFeature(feature);
        }
        return this.info.hasFeature(feature);
    }

    public boolean isDeterministic() {
        if (this.signature != null) {
            return this.signature.isDeterministic();
        }
        return this.info.isDeterministic();
    }

    public FunctionName fqnName() {
        if (this.signature != null) {
            return this.signature.getName();
        }
        return this.info.ident().fqnName();
    }

    public FunctionType type() {
        if (this.signature != null) {
            return this.signature.getKind();
        }
        return this.info.type();
    }

    @Nullable
    public Signature signature() {
        return this.signature;
    }

    @Nullable
    public Symbol filter() {
        return this.filter;
    }

    @Override
    public DataType<?> valueType() {
        return this.returnType;
    }

    @Override
    public Symbol cast(DataType<?> targetType, CastMode ... modes) {
        String name = this.signature != null ? this.signature.getName().name() : this.info.ident().name();
        if (targetType instanceof ArrayType && name.equals("_array")) {
            return this.castArrayElements(targetType, modes);
        }
        return super.cast(targetType, modes);
    }

    private Symbol castArrayElements(DataType<?> newDataType, CastMode ... modes) {
        DataType innerType = ((ArrayType)newDataType).innerType();
        ArrayList<Symbol> newArgs = new ArrayList<Symbol>(this.arguments.size());
        for (Symbol arg : this.arguments) {
            try {
                newArgs.add(arg.cast(innerType, modes));
            }
            catch (ConversionException e) {
                throw new ConversionException(this.returnType, newDataType);
            }
        }
        return new Function(this.signature, newArgs, newDataType, null);
    }

    @Override
    public SymbolType symbolType() {
        return SymbolType.FUNCTION;
    }

    @Override
    public <C, R> R accept(SymbolVisitor<C, R> visitor, C context) {
        return visitor.visitFunction(this, context);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.info.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_4_1_0)) {
            Symbols.nullableToStream(this.filter, out);
        }
        Symbols.toStream(this.arguments, out);
        if (out.getVersion().onOrAfter(Version.V_4_2_0)) {
            out.writeBoolean(this.signature != null);
            if (this.signature != null) {
                this.signature.writeTo(out);
                DataTypes.toStream(this.returnType, out);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Function function = (Function)o;
        return Objects.equals(this.arguments, function.arguments) && Objects.equals(this.info, function.info) && Objects.equals(this.filter, function.filter);
    }

    public int hashCode() {
        return Objects.hash(this.arguments, this.info, this.filter);
    }

    @Override
    public String toString(Style style) {
        String name;
        StringBuilder builder = new StringBuilder();
        switch (name = this.signature.getName().name()) {
            case "match": {
                MatchPrinter.printMatchPredicate(this, style, builder);
                break;
            }
            case "_negate": {
                this.printNegate(builder, style);
                break;
            }
            case "subscript": 
            case "subscript_obj": {
                this.printSubscriptFunction(builder, style);
                break;
            }
            case "_subscript_record": {
                this.printSubscriptRecord(builder, style);
                break;
            }
            case "current_user": {
                builder.append("CURRENT_USER");
                break;
            }
            case "session_user": {
                builder.append("SESSION_USER");
                break;
            }
            case "current_schemas": {
                builder.append("current_schemas");
                break;
            }
            case "current_schema": {
                builder.append("current_schema");
                break;
            }
            case "op_isnull": {
                builder.append("(");
                builder.append(this.arguments.get(0).toString(style));
                builder.append(" IS NULL)");
                break;
            }
            case "op_not": {
                builder.append("(NOT ");
                builder.append(this.arguments.get(0).toString(style));
                builder.append(")");
                break;
            }
            case "count": {
                if (this.arguments.isEmpty()) {
                    builder.append("count(*)");
                    this.printFilter(builder, style);
                    break;
                }
                this.printFunctionWithParenthesis(builder, style);
                break;
            }
            case "current_timestamp": {
                if (this.arguments.isEmpty()) {
                    builder.append("CURRENT_TIMESTAMP");
                    break;
                }
                this.printFunctionWithParenthesis(builder, style);
                break;
            }
            case "current_time": {
                if (this.arguments.isEmpty()) {
                    builder.append("CURRENT_TIME");
                    break;
                }
                this.printFunctionWithParenthesis(builder, style);
                break;
            }
            default: {
                if (name.startsWith("any_")) {
                    this.printAnyOperator(builder, style);
                    break;
                }
                if (name.equalsIgnoreCase("_cast") || name.equalsIgnoreCase("cast") || name.equalsIgnoreCase("try_cast")) {
                    this.printCastFunction(builder, style);
                    break;
                }
                if (name.startsWith("op_")) {
                    this.printOperator(builder, style, null);
                    break;
                }
                if (name.startsWith("extract_")) {
                    this.printExtract(builder, style);
                    break;
                }
                String arithmeticOperator = ARITHMETIC_OPERATOR_MAPPING.get(name);
                if (arithmeticOperator != null) {
                    this.printOperator(builder, style, arithmeticOperator);
                    break;
                }
                this.printFunctionWithParenthesis(builder, style);
            }
        }
        return builder.toString();
    }

    private void printNegate(StringBuilder builder, Style style) {
        builder.append("- ");
        builder.append(this.arguments.get(0).toString(style));
    }

    private void printSubscriptRecord(StringBuilder builder, Style style) {
        builder.append("(");
        builder.append(this.arguments.get(0).toString(style));
        builder.append(").");
        builder.append(this.arguments.get(1).toString(style));
    }

    private void printAnyOperator(StringBuilder builder, Style style) {
        String name = this.signature.getName().name();
        assert (name.startsWith("any_")) : "function for printAnyOperator must start with any prefix";
        assert (this.arguments.size() == 2) : "function's number of arguments must be 2";
        String operatorName = name.substring(4).replace('_', ' ').toUpperCase(Locale.ENGLISH);
        builder.append("(").append(this.arguments.get(0).toString(style)).append(" ").append(operatorName).append(" ").append("ANY(").append(this.arguments.get(1).toString(style)).append("))");
    }

    private void printCastFunction(StringBuilder builder, Style style) {
        String name = this.info.ident().name();
        DataType<?> targetType = this.info.returnType();
        builder.append(name).append("(").append(this.arguments().get(0).toString(style));
        if (name.equalsIgnoreCase("_cast")) {
            builder.append(", ").append(this.arguments.get(1).toString(style));
        } else {
            builder.append(" AS ").append(targetType.getTypeSignature().toString());
        }
        builder.append(")");
    }

    private void printExtract(StringBuilder builder, Style style) {
        String name = this.info.ident().name();
        assert (name.startsWith("extract_")) : "name of function passed to printExtract must start with extract_";
        String fieldName = name.substring("extract_".length());
        builder.append("extract(").append(fieldName).append(" FROM ");
        builder.append(this.arguments.get(0).toString(style));
        builder.append(")");
    }

    private void printOperator(StringBuilder builder, Style style, String operator) {
        if (operator == null) {
            String name = this.info.ident().name();
            assert (name.startsWith("op_"));
            operator = name.substring("op_".length()).toUpperCase(Locale.ENGLISH);
        }
        builder.append("(").append(this.arguments.get(0).toString(style)).append(" ").append(operator).append(" ").append(this.arguments.get(1).toString(style)).append(")");
    }

    private void printSubscriptFunction(StringBuilder builder, Style style) {
        Symbol base = this.arguments.get(0);
        if (base instanceof Reference && base.valueType() instanceof ArrayType && ((Reference)base).column().path().size() > 0) {
            Reference firstArgument = (Reference)base;
            builder.append(firstArgument.column().name());
            builder.append("[");
            builder.append(this.arguments.get(1).toString(style));
            builder.append("]");
            builder.append("['");
            builder.append(firstArgument.column().path().get(0));
            builder.append("']");
        } else {
            builder.append(base.toString(style));
            builder.append("[");
            builder.append(this.arguments.get(1).toString(style));
            builder.append("]");
        }
    }

    private void printFunctionWithParenthesis(StringBuilder builder, Style style) {
        FunctionName functionName = this.info.ident().fqnName();
        builder.append(functionName.displayName());
        builder.append("(");
        for (int i = 0; i < this.arguments.size(); ++i) {
            Symbol argument = this.arguments.get(i);
            builder.append(argument.toString(style));
            if (i + 1 >= this.arguments.size()) continue;
            builder.append(", ");
        }
        builder.append(")");
        this.printFilter(builder, style);
    }

    private void printFilter(StringBuilder builder, Style style) {
        if (this.filter != null) {
            builder.append(" FILTER (WHERE ");
            builder.append(this.filter.toString(style));
            builder.append(")");
        }
    }
}

