/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.symbol;

import io.crate.expression.symbol.InputColumn;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolType;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.expression.symbol.format.Style;
import io.crate.metadata.Reference;
import io.crate.types.DataType;
import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class FetchReference
extends Symbol {
    private final InputColumn fetchId;
    private final Reference ref;

    public FetchReference(InputColumn fetchId, Reference ref) {
        this.fetchId = fetchId;
        this.ref = ref;
    }

    @Override
    public SymbolType symbolType() {
        return SymbolType.FETCH_REFERENCE;
    }

    @Override
    public <C, R> R accept(SymbolVisitor<C, R> visitor, C context) {
        return visitor.visitFetchReference(this, context);
    }

    @Override
    public DataType<?> valueType() {
        return this.ref.valueType();
    }

    public InputColumn fetchId() {
        return this.fetchId;
    }

    public Reference ref() {
        return this.ref;
    }

    public FetchReference(StreamInput in) throws IOException {
        throw new UnsupportedOperationException("FetchReference cannot be streamed");
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("FetchReference cannot be streamed");
    }

    @Override
    public String toString(Style style) {
        return "FETCH(" + this.fetchId.toString(style) + ", " + this.ref.toString(style) + ")";
    }
}

