/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.symbol;

import io.crate.analyze.FrameBoundDefinition;
import io.crate.analyze.OrderBy;
import io.crate.analyze.WindowDefinition;
import io.crate.expression.symbol.AliasSymbol;
import io.crate.expression.symbol.FetchReference;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.MatchPredicate;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.expression.symbol.WindowFunction;

public abstract class DefaultTraversalSymbolVisitor<C, R>
extends SymbolVisitor<C, R> {
    @Override
    public R visitFunction(Function symbol, C context) {
        for (Symbol arg : symbol.arguments()) {
            arg.accept(this, context);
        }
        Symbol filter = symbol.filter();
        if (filter != null) {
            filter.accept(this, context);
        }
        return null;
    }

    @Override
    public R visitWindowFunction(WindowFunction symbol, C context) {
        Symbol frameEndValueSymbol;
        FrameBoundDefinition end;
        WindowDefinition windowDefinition;
        OrderBy orderBy;
        for (Symbol arg : symbol.arguments()) {
            arg.accept(this, context);
        }
        Symbol filter = symbol.filter();
        if (filter != null) {
            filter.accept(this, context);
        }
        if ((orderBy = (windowDefinition = symbol.windowDefinition()).orderBy()) != null) {
            for (Symbol orderBySymbol : orderBy.orderBySymbols()) {
                orderBySymbol.accept(this, context);
            }
        }
        for (Symbol partition : windowDefinition.partitions()) {
            partition.accept(this, context);
        }
        Symbol frameStartValueSymbol = windowDefinition.windowFrameDefinition().start().value();
        if (frameStartValueSymbol != null) {
            frameStartValueSymbol.accept(this, context);
        }
        if ((end = windowDefinition.windowFrameDefinition().end()) != null && (frameEndValueSymbol = end.value()) != null) {
            frameEndValueSymbol.accept(this, context);
        }
        return null;
    }

    @Override
    public R visitFetchReference(FetchReference fetchReference, C context) {
        fetchReference.fetchId().accept(this, context);
        fetchReference.ref().accept(this, context);
        return null;
    }

    @Override
    public R visitMatchPredicate(MatchPredicate matchPredicate, C context) {
        for (Symbol field : matchPredicate.identBoostMap().keySet()) {
            field.accept(this, context);
        }
        matchPredicate.queryTerm().accept(this, context);
        matchPredicate.options().accept(this, context);
        return null;
    }

    @Override
    public R visitAlias(AliasSymbol aliasSymbol, C context) {
        aliasSymbol.symbol().accept(this, context);
        return null;
    }
}

